/*
 * Decompiled with CFR 0.152.
 */
package fox.mods.access_denied.requirements;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.logging.LogUtils;
import fox.mods.access_denied.requirements.DimensionRequirement;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.loading.FMLPaths;
import org.slf4j.Logger;

public class DimensionRequirementsLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new Gson();
    private static final File CONFIG_DIR = new File(FMLPaths.CONFIGDIR.get().toFile(), "access_denied");
    private static final Map<String, DimensionRequirement> DIMENSION_REQUIREMENTS = new HashMap<String, DimensionRequirement>();

    public static Map<String, DimensionRequirement> getRequirements() {
        return DIMENSION_REQUIREMENTS;
    }

    public static void loadRequirements() {
        File[] files;
        DIMENSION_REQUIREMENTS.clear();
        if (!CONFIG_DIR.exists() && CONFIG_DIR.mkdirs()) {
            LOGGER.info("Created config folder: {}", (Object)CONFIG_DIR.getAbsolutePath());
        }
        if ((files = CONFIG_DIR.listFiles((dir, name) -> name.endsWith(".json"))) == null) {
            LOGGER.warn("No requirement files found in {}", (Object)CONFIG_DIR.getAbsolutePath());
            return;
        }
        for (File file : files) {
            try (FileReader reader = new FileReader(file);){
                JsonObject obj = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                if (!obj.has("dimension")) {
                    LOGGER.warn("File {} skipped: missing 'dimension' key", (Object)file.getName());
                    continue;
                }
                String dimensionKey = obj.get("dimension").getAsString();
                ResourceLocation dimensionId = ResourceLocation.tryParse((String)dimensionKey);
                if (dimensionId == null) {
                    LOGGER.error("Invalid dimension ID '{}' in file {}", (Object)dimensionKey, (Object)file.getName());
                    continue;
                }
                String dimensionString = dimensionId.toString();
                if (DIMENSION_REQUIREMENTS.containsKey(dimensionString)) {
                    LOGGER.warn("Duplicate definition for dimension {} found in file {} \u2014 skipping!", (Object)dimensionString, (Object)file.getName());
                    continue;
                }
                DimensionRequirement requirement = (DimensionRequirement)GSON.fromJson((JsonElement)obj, DimensionRequirement.class);
                DIMENSION_REQUIREMENTS.put(dimensionString, requirement);
                LOGGER.info("Loaded requirements for dimension {} from file {}", (Object)dimensionString, (Object)file.getName());
            }
            catch (JsonSyntaxException | IOException e) {
                LOGGER.error("Failed to read requirement file: {}", (Object)file.getName(), (Object)e);
            }
        }
    }
}

