/*
 * Decompiled with CFR 0.152.
 */
package fox.mods.access_denied.util;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class RegistriesUtils {
    public static Item itemFromRegistryName(String registryName) {
        if (registryName == null) {
            return Items.AIR;
        }
        ResourceLocation id = ResourceLocation.parse((String)registryName);
        Optional holderOpt = BuiltInRegistries.ITEM.get(id);
        return holderOpt.map(Holder.Reference::value).orElse(null);
    }

    public static Holder.Reference<MobEffect> effectFromRegistryName(String registryName) {
        if (registryName == null) {
            registryName = "minecraft:instant_health";
        }
        ResourceLocation id = ResourceLocation.parse((String)registryName);
        return BuiltInRegistries.MOB_EFFECT.get(id).orElse(null);
    }

    public static String getEffectDisplayName(Holder.Reference<MobEffect> effect) {
        if (effect == null) {
            return "";
        }
        Component displayName = ((MobEffect)effect.value()).getDisplayName();
        return displayName.getString();
    }

    public static String getAdvancementDisplayName(MinecraftServer server, String advancementRegistryId) {
        if (advancementRegistryId == null) {
            return "";
        }
        ResourceLocation id = ResourceLocation.parse((String)advancementRegistryId);
        ServerAdvancementManager mgr = server.getAdvancements();
        AdvancementHolder holder = mgr.get(id);
        if (holder == null) {
            return "";
        }
        Component titleComp = Advancement.name((AdvancementHolder)holder);
        String title = titleComp.getString();
        return title;
    }

    public static String getMobNameFromRegistryName(String registryName) {
        if (registryName == null) {
            return null;
        }
        EntityType entityType = EntityType.byString((String)registryName).orElse(null);
        if (entityType == null) {
            return null;
        }
        String translationKey = entityType.getDescriptionId();
        return Component.translatable((String)translationKey).getString();
    }

    public static String getBlockNameFromRegistryName(String registryName) {
        if (registryName == null) {
            return null;
        }
        ResourceLocation resourceLocation = ResourceLocation.parse((String)registryName);
        Block block = (Block)BuiltInRegistries.BLOCK.getValue(resourceLocation);
        return block.getName().getString();
    }

    public static String getBiomeDisplayNameFromRegistryName(@Nullable String registryName, Level level) {
        if (registryName == null || registryName.isEmpty()) {
            return "Unknown Biome";
        }
        ResourceLocation biomeId = ResourceLocation.tryParse((String)registryName);
        if (biomeId == null) {
            return "Unknown Biome";
        }
        Registry biomeRegistry = level.registryAccess().lookupOrThrow(Registries.BIOME);
        ResourceKey biomeKey = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)biomeId);
        Optional biomeHolderOpt = biomeRegistry.get(biomeKey);
        String biomeName = "";
        if (biomeHolderOpt.isPresent()) {
            biomeName = Component.translatable((String)("biome." + biomeKey.location().getNamespace() + "." + biomeKey.location().getPath())).getString();
        }
        return biomeName;
    }

    public static String getDimensionDisplayNameFromRegistryName(@Nullable String registryName) {
        if (registryName == null || registryName.isEmpty()) {
            return "Unknown Dimension";
        }
        ResourceLocation dimensionId = ResourceLocation.tryParse((String)registryName);
        if (dimensionId == null) {
            return "Unknown Dimension";
        }
        String translationKey = "dimension." + dimensionId.getNamespace() + "." + dimensionId.getPath();
        MutableComponent translatedComponent = Component.translatable((String)translationKey);
        String translated = translatedComponent.getString();
        if (translated.equals(translationKey)) {
            String path = dimensionId.getPath();
            String[] words = path.split("_");
            StringBuilder builder = new StringBuilder();
            for (String word : words) {
                if (word.isEmpty()) continue;
                builder.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
            }
            translated = builder.toString().trim();
        }
        return translated;
    }
}

