/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.ai;

import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.block.resin.vent.ResinVentBlock;
import com.alien.common.gameplay.entity.living.alien.xenomorph.Xenomorph;
import com.alien.common.model.alien.variant.AlienVariantType;
import com.avp.common.registry.AVPDeferredHolder;
import com.avp.common.registry.tag.AVPBlockTags;
import com.lib.common.data.Cooldown;
import com.lib.common.util.DirectionUtil;
import java.time.Duration;
import java.util.EnumSet;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1352;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class CreateVentGoal
extends class_1352 {
    private static final int WALL_DEPTH = 3;
    private static final int WALL_TOTAL_DEPTH = 4;
    private final Cooldown cooldown;
    private final Xenomorph xenomorph;
    private final class_1937 level;
    private class_2338 wallStart;
    private class_2350 direction;
    private boolean drillingStarted;

    public CreateVentGoal(Xenomorph xenomorph) {
        this.xenomorph = xenomorph;
        this.cooldown = Cooldown.withCooldownTime("cooldown", Duration.ofSeconds(15L));
        this.level = xenomorph.method_37908();
        this.drillingStarted = false;
        this.cooldown.reset();
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
        this.cooldown.tick();
        if (this.isUnableToCreateVent()) {
            return false;
        }
        class_2338 footPos = this.xenomorph.method_24515();
        for (class_2350 dir : class_2350.class_2353.field_11062) {
            class_239 hit = this.rayTraceToSolid(footPos, dir);
            if (!(hit instanceof class_3965)) continue;
            class_3965 bhr = (class_3965)hit;
            class_2338 hitPos = bhr.method_17777();
            boolean ventAlreadyExists = this.xenomorph.getHiveManager().hive().isSomeAnd(hive -> !hive.getVentManager().getVentsWithinSection(hitPos).isEmpty());
            if (ventAlreadyExists || !this.isValidWall(hitPos, dir)) continue;
            class_2338 pathTarget = hitPos.method_10079(dir, 3);
            class_11 path = this.xenomorph.method_5942().method_6348(pathTarget, 1);
            if (path == null || !path.method_21655()) continue;
            this.wallStart = hitPos;
            this.direction = dir;
            return true;
        }
        return false;
    }

    public void method_6269() {
        class_2338 pathTarget = this.wallStart.method_10079(this.direction, 3);
        this.xenomorph.method_5942().method_6337((double)pathTarget.method_10263() + 0.5, (double)pathTarget.method_10264(), (double)pathTarget.method_10260() + 0.5, 0.5);
    }

    public void method_6268() {
        if (this.drillingStarted || !this.xenomorph.method_5942().method_6357()) {
            return;
        }
        this.drillingStarted = true;
        AlienVariantType alienVariantType = AlienVariantTypes.getFor(this.xenomorph);
        AVPDeferredHolder<class_2248> resinHolder = alienVariantType.resin();
        AVPDeferredHolder<ResinVentBlock> resinVentHolder = alienVariantType.resinVent();
        AVPDeferredHolder<class_2248> resinWebHolder = alienVariantType.resinWeb();
        for (int i = 0; i < 3; ++i) {
            class_2338 tunnelPos = this.wallStart.method_10079(this.direction, i);
            this.level.method_8652(tunnelPos, resinWebHolder.get().method_9564(), 3);
            for (class_2350 relativeDirection : DirectionUtil.VALUES) {
                if (relativeDirection == this.direction || relativeDirection == this.direction.method_10153()) continue;
                class_2338 tunnelWallPos = tunnelPos.method_10093(relativeDirection);
                this.level.method_8652(tunnelWallPos, resinHolder.get().method_9564(), 3);
            }
        }
        class_2338 ventPos = this.wallStart.method_10079(this.direction, 3);
        this.level.method_8652(ventPos, resinVentHolder.get().method_9564(), 3);
        this.cooldown.reset();
    }

    public boolean method_6266() {
        return !this.isUnableToCreateVent() && !this.drillingStarted;
    }

    public void method_6270() {
        this.drillingStarted = false;
        this.wallStart = null;
        this.direction = null;
    }

    private boolean isUnableToCreateVent() {
        return this.xenomorph.method_5968() != null || this.xenomorph.getHiveManager().hive().isNoneOr(hive -> !hive.isAlive() || hive.isAngry() || !hive.getSpaceManager().isEntityWithinHive((class_1297)this.xenomorph)) || this.cooldown.isActive();
    }

    private class_239 rayTraceToSolid(class_2338 start, class_2350 dir) {
        class_243 from = class_243.method_24953((class_2382)start);
        class_243 to = from.method_1019(class_243.method_24954((class_2382)dir.method_10163()).method_1021(16.0));
        return this.level.method_17742(new class_3959(from, to, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.xenomorph));
    }

    private boolean isValidWall(class_2338 start, class_2350 direction) {
        for (int i = 0; i < 3; ++i) {
            class_2338 tunnelPos = start.method_10079(direction, i);
            if (!this.isTunnelPosClear(tunnelPos)) {
                return false;
            }
            for (class_2350 adj : DirectionUtil.VALUES) {
                class_2338 tunnelWallPos;
                if (adj == direction || adj == direction.method_10153() || this.isTunnelWallReplaceable(tunnelWallPos = tunnelPos.method_10093(adj))) continue;
                return false;
            }
        }
        class_2338 ventPos = start.method_10079(direction, 3);
        return this.isTunnelPosClear(ventPos);
    }

    private boolean isTunnelPosClear(class_2338 pos) {
        class_2680 blockState = this.level.method_8320(pos);
        return blockState.method_26215() || this.isTunnelWallReplaceable(pos);
    }

    private boolean isTunnelWallReplaceable(class_2338 pos) {
        class_2680 blockState = this.level.method_8320(pos);
        AlienVariantType alienVariantType = AlienVariantTypes.getFor(this.xenomorph);
        if (blockState.method_26164(AVPBlockTags.XENOMORPH_IMMUNE)) {
            return false;
        }
        return blockState.method_27852(alienVariantType.resin().get()) || blockState.method_26164(alienVariantType.resinReplaceableTag());
    }
}

