/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.acid;

import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.entity.acid.AcidBlockDamageUtil;
import com.alien.common.gameplay.entity.acid.AcidEntityDamageUtil;
import com.alien.common.model.alien.variant.AlienVariantType;
import com.avp.common.registry.init.AVPDataKeys;
import com.just.core.functional.option.Option;
import com.lib.common.gameplay.util.GravityUtil;
import com.lib.common.network.DataAccessor;
import com.lib.common.network.DataUser;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.jetbrains.annotations.NotNull;

public class Acid
extends class_1297
implements DataUser {
    public static final int MAX_MULTIPLIER = 5;
    private static final int DEFAULT_MAX_LIFE_IN_TICKS = 400;
    private static final int MIN_TICKS_UNTIL_PARTICLES = 5;
    private static final String IS_NETHER_AFFLICTED_KEY = "isNetherAfflicted";
    private static final String IS_IRRADIATED_KEY = "isIrradiated";
    private static final class_2940<Boolean> IS_NETHER_AFFLICTED = class_2945.method_12791(Acid.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> IS_IRRADIATED = class_2945.method_12791(Acid.class, (class_2941)class_2943.field_13323);
    public final DataAccessor<Integer> multiplier = new DataAccessor<Integer>(this, AVPDataKeys.ACID_MULTIPLIER);
    public final DataAccessor<Integer> tickCountForCurrentMultiplier = new DataAccessor<Integer>(this, AVPDataKeys.ACID_TICK_COUNT_FOR_MULTIPLIER);
    private int particleTickCounter = 0;

    public Acid(class_1299<? extends class_1297> entityType, class_1937 level) {
        super(entityType, level);
        this.method_5875(false);
        this.method_18382();
        this.multiplier.onChange($ -> this.method_18382());
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(IS_NETHER_AFFLICTED, (Object)false);
        builder.method_56912(IS_IRRADIATED, (Object)false);
    }

    public void method_5773() {
        super.method_5773();
        class_1937 level = this.method_37908();
        if (!level.field_9236 && !this.field_5976) {
            GravityUtil.apply(this);
        }
        AcidBlockDamageUtil.damageBlocks(this);
        AcidEntityDamageUtil.damageEntities(this);
        this.particleTickCounter += this.getMultiplier();
        this.createParticlesAndSounds(level);
        if (!level.field_9236) {
            int increment = this.getMultiplier() * (this.method_5799() ? 2 : 1);
            this.tickCountForCurrentMultiplier.set(this.tickCountForCurrentMultiplier.get() + increment);
            if (this.tickCountForCurrentMultiplier.get() > 400) {
                this.decreaseMultiplier();
                this.tickCountForCurrentMultiplier.reset();
            }
            if (this.getMultiplier() == 0) {
                this.method_5768();
            }
        }
    }

    public boolean isNetherAfflicted() {
        return (Boolean)this.field_6011.method_12789(IS_NETHER_AFFLICTED);
    }

    public void setNetherAfflicted(boolean isNetherAfflicted) {
        this.field_6011.method_12778(IS_NETHER_AFFLICTED, (Object)isNetherAfflicted);
    }

    public boolean isIrradiated() {
        return (Boolean)this.field_6011.method_12789(IS_IRRADIATED);
    }

    public void setIrradiated(boolean isIrradiated) {
        this.field_6011.method_12778(IS_IRRADIATED, (Object)isIrradiated);
    }

    protected void method_5749(@NotNull class_2487 compoundTag) {
        this.setNetherAfflicted(compoundTag.method_10577(IS_NETHER_AFFLICTED_KEY));
        this.setIrradiated(compoundTag.method_10577(IS_IRRADIATED_KEY));
    }

    protected void method_5652(@NotNull class_2487 compoundTag) {
        compoundTag.method_10556(IS_NETHER_AFFLICTED_KEY, this.isNetherAfflicted());
        compoundTag.method_10556(IS_IRRADIATED_KEY, this.isIrradiated());
    }

    public void decreaseMultiplier() {
        this.setMultiplier(this.getMultiplier() - 1);
    }

    private void createParticlesAndSounds(class_1937 level) {
        if (!level.field_9236) {
            return;
        }
        if (this.particleTickCounter < 5) {
            return;
        }
        this.particleTickCounter = 0;
        Option<AlienVariantType> alienVariantTypeOption = AlienVariantTypes.getFor(this);
        for (int i = 0; i < this.getMultiplier(); ++i) {
            if (this.method_5799()) {
                level.method_8494((class_2394)class_2398.field_11238, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), 0.0, 0.0, 0.0);
            }
            alienVariantTypeOption.ifSome(alienVariantType -> level.method_8494((class_2394)alienVariantType.acidParticleType().get(), this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), 0.0, 0.0, 0.0));
        }
    }

    public int getMultiplier() {
        return this.multiplier.get();
    }

    public void setMultiplier(int multiplier) {
        this.multiplier.set(class_3532.method_15340((int)multiplier, (int)0, (int)5));
        this.tickCountForCurrentMultiplier.reset();
        this.method_18382();
    }

    @NotNull
    public class_4048 method_18377(@NotNull class_4050 pose) {
        class_4048 originalDimensions = super.method_18377(pose);
        float originalWidth = originalDimensions.comp_2185();
        float maxScale = 1.0f / originalWidth;
        float scaleStep = class_3532.method_37959((float)this.getMultiplier(), (float)0.0f, (float)5.0f, (float)1.0f, (float)maxScale);
        return originalDimensions.method_19539(scaleStep, 1.0f);
    }

    public boolean method_5753() {
        return true;
    }

    public void age() {
        this.tickCountForCurrentMultiplier.set(this.tickCountForCurrentMultiplier.get() + this.getMultiplier());
    }
}

