/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.acid;

import com.alien.common.gameplay.entity.acid.Acid;
import com.avp.common.registry.init.AVPSoundEvents;
import com.avp.common.registry.tag.AVPBlockTags;
import com.avp.server.BlockBreakProgressManager;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3419;

public class AcidBlockDamageUtil {
    public static void damageBlocks(Acid acid) {
        class_1937 level = acid.method_37908();
        class_2338.method_29715((class_238)acid.method_5829().method_1009(0.0, 0.1, 0.0)).filter(blockPos -> AcidBlockDamageUtil.canAcidDestroyBlock(acid, blockPos, level)).forEach(blockPos -> AcidBlockDamageUtil.tryDestroyBlock(acid, blockPos, level));
    }

    private static void tryDestroyBlock(Acid acid, class_2338 blockPos, class_1937 level) {
        if (!level.field_9236) {
            if (acid.method_5799() || !acid.method_24828()) {
                return;
            }
            AcidBlockDamageUtil.damageBlock(acid, blockPos, level);
        } else {
            AcidBlockDamageUtil.spawnClientSideParticles(acid, level);
        }
    }

    private static void damageBlock(Acid acid, class_2338 blockPos, class_1937 level) {
        BlockBreakProgressManager.Result result = BlockBreakProgressManager.damage(level, blockPos, 0.2f * (float)acid.getMultiplier());
        switch (result) {
            case DAMAGED: {
                class_2338 above;
                if (!acid.isNetherAfflicted() || !level.method_8320(above = blockPos.method_10084()).method_26215()) break;
                level.method_8501(above, class_2246.field_10036.method_9564());
                break;
            }
            case DESTROYED: {
                if (!acid.isIrradiated()) break;
                level.method_8501(blockPos, class_2246.field_10384.method_9564());
            }
        }
        if (result != BlockBreakProgressManager.Result.NOT_DAMAGED) {
            if (acid.field_6012 % (acid.method_59922().method_43048(100) + 10) == 0) {
                level.method_43129(null, (class_1297)acid, AVPSoundEvents.BLOCK_ACID_BURN.get(), class_3419.field_15254, 1.0f, 1.0f);
            }
            acid.age();
        }
    }

    private static void spawnClientSideParticles(Acid acid, class_1937 level) {
        if (acid.isIrradiated()) {
            return;
        }
        level.method_8494((class_2394)class_2398.field_11251, acid.method_23322(0.5), acid.method_23319(), acid.method_23325(0.5), 0.0, 0.0, 0.0);
    }

    private static boolean canAcidDestroyBlock(Acid acid, class_2338 blockPos, class_1937 level) {
        class_2680 blockState = level.method_8320(blockPos);
        if (blockState.method_26215()) {
            return false;
        }
        if (acid.isNetherAfflicted()) {
            return !blockState.method_26164(AVPBlockTags.NETHER_ACID_IMMUNE);
        }
        if (acid.isIrradiated()) {
            return !blockState.method_26164(AVPBlockTags.IRRADIATED_ACID_IMMUNE);
        }
        return !blockState.method_26164(AVPBlockTags.ACID_IMMUNE);
    }
}

