/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien;

import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.entity.living.alien.HiveManager;
import com.alien.common.gameplay.entity.living.alien.xenomorph.drone.Drone;
import com.alien.common.gameplay.entity.living.alien.xenomorph.runner.Runner;
import com.alien.common.gameplay.hive.Hive;
import com.alien.common.gameplay.level.saveddata.HiveLevelData;
import com.alien.common.gameplay.level.saveddata.StrainLeakData;
import com.alien.common.model.alien.variant.AlienVariant;
import com.alien.common.model.alien.variant.AlienVariantType;
import com.alien.common.util.AcidBleedUtil;
import com.alien.common.util.AlienTransitionUtil;
import com.avp.AVP;
import com.avp.common.config.AVPConfig;
import com.avp.common.registry.init.AVPDataKeys;
import com.avp.common.registry.key.AVPBiomeKeys;
import com.avp.common.registry.tag.AVPDamageTypesTags;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.avp.common.registry.tag.AVPMobEffectTags;
import com.avp.common.util.MovementAnalyzer;
import com.just.core.functional.option.Option;
import com.lib.common.gameplay.entity.manager.GeneContainer;
import com.lib.common.gameplay.entity.manager.GeneManager;
import com.lib.common.gameplay.entity.manager.VibrationSystemManager;
import com.lib.common.gameplay.gene.Genes;
import com.lib.common.model.GeneCarrier;
import com.lib.common.network.DataAccessor;
import com.lib.common.network.DataUser;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1588;
import net.minecraft.class_1690;
import net.minecraft.class_1695;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5715;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_7923;
import net.minecraft.class_8103;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Alien
extends class_1588
implements DataUser {
    private static final String NBT_HOST_TYPE = "hostType";
    private static final String NBT_JELLY_COUNT = "jellyCount";
    public final DataAccessor<Boolean> hasTarget = new DataAccessor<Boolean>(this, AVPDataKeys.ENTITY_HAS_TARGET);
    public final DataAccessor<Boolean> isPoisoned = new DataAccessor<Boolean>(this, AVPDataKeys.ALIEN_IS_POISONED);
    public final DataAccessor<Boolean> isMovingHorizontally = new DataAccessor<Boolean>(this, AVPDataKeys.ENTITY_IS_MOVING_HORIZONTALLY);
    protected final HiveManager hiveManager = new HiveManager(this);
    protected final MovementAnalyzer movementAnalyzer = new MovementAnalyzer((class_1297)this);
    private final VibrationSystemManager vibrationSystemManager = this.createVibrationSystemManager();
    private Option<class_1299<?>> hostTypeOption;
    private int jellyCount;
    private int lastHurtTimeInTicks;
    protected AVPConfig.StatsConfigs.AdvancedStats config;

    protected Alien(class_1299<? extends Alien> entityType, class_1937 level) {
        super(entityType, level);
        this.hostTypeOption = Option.ofNullable(this.getDefaultHostType(entityType));
        this.jellyCount = 0;
        this.lastHurtTimeInTicks = 0;
    }

    @Nullable
    public abstract class_1299<? extends Alien> getTypeForVariant(AlienVariant var1);

    protected abstract float getHealthRegenPerSecond();

    protected VibrationSystemManager createVibrationSystemManager() {
        return new VibrationSystemManager((class_1308)this, 2.5f, 32);
    }

    public float method_49476() {
        return 1.5f;
    }

    private class_1299<? extends class_1297> getDefaultHostType(class_1299<? extends Alien> entityType) {
        if (entityType.method_20210(AVPEntityTypeTags.RUNNERS) || entityType.method_20210(AVPEntityTypeTags.PROWLERS) || entityType.method_20210(AVPEntityTypeTags.CRUSHERS)) {
            return class_1299.field_6093;
        }
        if (entityType.method_20210(AVPEntityTypeTags.SPITTERS)) {
            return class_1299.field_6074;
        }
        return class_1299.field_6077;
    }

    protected boolean canBleedAcid() {
        return true;
    }

    protected boolean canHeal() {
        int requiredTicksAfterHurtToHeal = 200;
        return this.method_5968() == null && this.field_6012 > this.method_6117() + requiredTicksAfterHurtToHeal;
    }

    public void method_5980(@Nullable class_1309 livingEntity) {
        super.method_5980(livingEntity);
        if (livingEntity instanceof class_3222) {
            class_3222 player = (class_3222)livingEntity;
            this.hiveManager.hive().filter(hive -> hive.getSpaceManager().isEntityWithinHive((class_1297)player)).ifSome(hive -> hive.getBossBarManager().trackPlayer(player));
        }
    }

    public AlienVariant getVariant() {
        if (this.isAberrant()) {
            return AlienVariant.ABERRANT;
        }
        if (this.isIrradiated()) {
            return AlienVariant.IRRADIATED;
        }
        if (this.isNetherAfflicted()) {
            return AlienVariant.NETHER;
        }
        return AlienVariant.NORMAL;
    }

    public boolean isAberrant() {
        return Objects.equals(this.method_5864(), this.getTypeForVariant(AlienVariant.ABERRANT));
    }

    public boolean isIrradiated() {
        return Objects.equals(this.method_5864(), this.getTypeForVariant(AlienVariant.IRRADIATED));
    }

    public boolean isNetherAfflicted() {
        return Objects.equals(this.method_5864(), this.getTypeForVariant(AlienVariant.NETHER));
    }

    private void applyMalusBasedOnVariant() {
        if (this.isNetherAfflicted()) {
            this.method_5941(class_7.field_14, 0.0f);
            this.method_5941(class_7.field_9, 0.0f);
            this.method_5941(class_7.field_3, 0.0f);
        } else {
            this.method_5941(class_7.field_14, class_7.field_14.method_11());
            this.method_5941(class_7.field_9, class_7.field_9.method_11());
            this.method_5941(class_7.field_3, class_7.field_3.method_11());
        }
    }

    public int getJellyCount() {
        return this.jellyCount;
    }

    public void setJellyCount(int jellyCount) {
        this.jellyCount = Math.max(jellyCount, 0);
    }

    public boolean isPoisoned() {
        return this.isPoisoned.get();
    }

    public void setPoisoned(boolean isPoisoned) {
        this.isPoisoned.set(isPoisoned);
    }

    public boolean isRoyal() {
        return this.method_5864().method_20210(AVPEntityTypeTags.ROYAL_ALIENS);
    }

    protected boolean canEntityRideAlien(@NotNull class_1297 passenger) {
        return false;
    }

    protected final boolean method_5818(@NotNull class_1297 passenger) {
        return super.method_5818(passenger) && this.canEntityRideAlien(passenger);
    }

    protected boolean canAlienRideVehicle(@NotNull class_1297 vehicle) {
        return !(vehicle instanceof class_1690) && !(vehicle instanceof class_1695);
    }

    protected final boolean method_5860(@NotNull class_1297 vehicle) {
        return super.method_5860(vehicle) && this.canAlienRideVehicle(vehicle);
    }

    @Nullable
    public class_1315 method_5943(@NotNull class_5425 level, @NotNull class_1266 difficulty, @NotNull class_3730 spawnType, @Nullable class_1315 spawnGroupData) {
        AlienVariantType alienVariantType = AlienVariantTypes.getFor(this.getVariant());
        HiveLevelData.getOrCreate((class_1937)level.method_8410()).andThen(hiveLevelData -> hiveLevelData.findNearestHive(this.method_24515(), hive -> Objects.equals((Object)hive.getVariant(), (Object)alienVariantType.variant()))).ifSome(hive -> {
            boolean joinedHiveSuccessfully = this.hiveManager.tryJoinHive((Hive)hive);
            if (joinedHiveSuccessfully) {
                hive.getReserveManager().add(this.method_5864(), -1);
                hive.getLeadershipManager().getLeader().map(leader -> ((GeneCarrier)((Object)leader)).getOrCreateGeneManager().getGeneContainer()).ifSome(geneContainer -> {
                    GeneContainer alienGeneCarrier = ((GeneCarrier)((Object)this)).getOrCreateGeneManager().getGeneContainer();
                    geneContainer.transfer(alienGeneCarrier, true);
                });
            }
        });
        return super.method_5943(level, difficulty, spawnType, spawnGroupData);
    }

    public void method_5773() {
        super.method_5773();
        this.hiveManager.tick();
        this.vibrationSystemManager.tick();
        if (!this.method_37908().field_9236) {
            this.movementAnalyzer.tick();
            this.hasTarget.set(this.method_5968() != null);
            this.isMovingHorizontally.set(this.movementAnalyzer.isMovingHorizontally());
            if (this.method_5854() != null && !this.method_5860(this.method_5854())) {
                this.method_5848();
            }
            if (!this.method_5685().isEmpty()) {
                List<class_1297> passengersToRemove = this.method_5685().stream().filter(Predicate.not(this::canEntityRideAlien)).toList();
                passengersToRemove.forEach(class_1297::method_5848);
            }
            this.healPassively();
            this.applyMalusBasedOnVariant();
            this.applyDynamicAttributes(this.config);
            this.becomeIrradiated();
        }
    }

    public void method_42147(@NotNull BiConsumer<class_5715<?>, class_3218> biConsumer) {
        this.vibrationSystemManager.updateDynamicGameEventListener(biConsumer);
    }

    private void becomeIrradiated() {
        if (this.field_6012 % 60 != 0) {
            return;
        }
        if (!this.method_37908().method_23753(this.method_24515()).method_40225(AVPBiomeKeys.NUKED_BIOME)) {
            return;
        }
        if (!this.method_5805()) {
            return;
        }
        if (this.method_59922().method_39332(1, 100) >= 90) {
            AlienTransitionUtil.transitionIntoVariant(this, AlienVariant.IRRADIATED);
        }
    }

    private void healPassively() {
        if (this.field_6012 % 20 != 0) {
            return;
        }
        if (this.method_6032() >= this.method_6063()) {
            return;
        }
        if (!this.method_5805()) {
            return;
        }
        if (this.canHeal()) {
            this.method_6025(this.getHealthRegenPerSecond());
        }
    }

    public boolean method_5679(class_1282 damageSource) {
        return damageSource.method_48789(AVPDamageTypesTags.DOES_NOT_HURT_ALIENS) || super.method_5679(damageSource);
    }

    public boolean method_5874(@NotNull class_3218 level, @NotNull class_1309 entity) {
        boolean killedEntity = super.method_5874(level, entity);
        if (killedEntity && AlienVariantTypes.getFor(this.getVariant()).canReproduce() && !entity.method_5864().method_20210(AVPEntityTypeTags.ALIENS)) {
            this.hiveManager.hive().ifSome(hive -> {
                boolean wasRunnerHostKilled = entity.method_5864().method_20210(AVPEntityTypeTags.RUNNER_HOSTS);
                int bonusCount = 1 + (int)this.getGeneManager().getGeneContainer().getActiveGeneMap().getValue(Genes.BONUS_EMBRYO_COUNT);
                class_1299<? extends Alien> alienEntityType = wasRunnerHostKilled ? Runner.getType(hive.getVariant()) : Drone.getType(hive.getVariant());
                hive.getReserveManager().add(alienEntityType, bonusCount);
            });
        }
        return killedEntity;
    }

    public boolean method_5643(@NotNull class_1282 damageSource, float damage) {
        boolean isHurt = super.method_5643(damageSource, damage);
        if (isHurt) {
            class_1297 class_12972;
            this.lastHurtTimeInTicks = this.field_6012;
            AlienVariantType alienVariantType = AlienVariantTypes.getFor(this);
            if (this.isNetherAfflicted() && !damageSource.method_48789(class_8103.field_42260) && (class_12972 = damageSource.method_5526()) instanceof class_1309) {
                class_1309 livingEntity = (class_1309)class_12972;
                livingEntity.method_5639(4.0f);
            }
            if (damageSource.method_5529() != null) {
                this.method_32876(alienVariantType.cryForHelpEvent().getHolder());
            }
            if (this.canBleedAcid() && damageSource != this.method_48923().method_51847()) {
                class_243 randomPos = AcidBleedUtil.computeRandomPosFromBoundingBox((class_1309)this);
                AcidBleedUtil.spawnAcid((class_1309)this, damage, randomPos);
            }
        }
        return isHurt;
    }

    public int method_5669() {
        return Integer.MAX_VALUE;
    }

    protected float method_6120() {
        return 0.9f;
    }

    public int method_23329(float fallDistance, float damageMultiplier) {
        return fallDistance < 16.0f ? 0 : super.method_23329(fallDistance, damageMultiplier);
    }

    public int method_5850() {
        return 14;
    }

    public boolean method_6049(class_1293 mobEffectInstance) {
        if (mobEffectInstance.method_5579().method_40220(AVPMobEffectTags.DOES_NOT_AFFECT_ALIENS)) {
            return false;
        }
        return super.method_6049(mobEffectInstance);
    }

    public boolean method_33189() {
        return true;
    }

    public boolean method_5753() {
        return this.isNetherAfflicted() || super.method_5753();
    }

    public boolean method_5947() {
        return super.method_5947() || this.hiveManager.hive().filter(hive -> hive.isAngry() || hive.getLeadershipManager().isLeader((class_1297)this)).isSome();
    }

    public void method_5650(@NotNull class_1297.class_5529 removalReason) {
        super.method_5650(removalReason);
        switch (removalReason) {
            case field_26998: {
                this.hiveManager.hive().ifSome(hive -> hive.removeHiveMember((class_1297)this));
                break;
            }
            case field_26999: {
                this.hiveManager.hive().ifSome(hive -> {
                    hive.removeHiveMember((class_1297)this);
                    if (hive.getSpaceManager().isEntityWithinHive((class_1297)this)) {
                        hive.getReserveManager().add(this.method_5864(), 1);
                    } else {
                        StrainLeakData.getOrCreate(this.method_37908()).ifSome(strainLeakData -> {
                            AlienVariant alienVariant = this.getVariant();
                            boolean wasAlienVariantAlreadyPresent = strainLeakData.hasVariant(alienVariant);
                            AlienVariantType alienVariantType = AlienVariantTypes.getFor(this);
                            class_1937 patt0$temp = this.method_37908();
                            if (!(patt0$temp instanceof class_3218)) {
                                return;
                            }
                            class_3218 serverLevel = (class_3218)patt0$temp;
                            String strainBasedLeakMessage = this.getStrainLeakMessageForVariant(alienVariant);
                            if (strainBasedLeakMessage == null) {
                                return;
                            }
                            strainLeakData.add(alienVariant, 1);
                            if (!wasAlienVariantAlreadyPresent) {
                                for (class_3222 player : serverLevel.method_18456()) {
                                    player.method_43496((class_2561)class_2561.method_43470((String)strainBasedLeakMessage).method_27695(new class_124[]{alienVariantType.chatColor(), class_124.field_1056}));
                                }
                            }
                        });
                    }
                });
                break;
            }
        }
    }

    @Nullable
    private String getStrainLeakMessageForVariant(AlienVariant alienVariant) {
        return switch (alienVariant) {
            default -> throw new MatchException(null, null);
            case AlienVariant.NORMAL -> "The perfect organism has found a new world to conquer...";
            case AlienVariant.NETHER -> "Hell has found its way into this plane of existence...";
            case AlienVariant.ABERRANT -> "Genetic experiments have found their way into the wide open world...";
            case AlienVariant.IRRADIATED -> null;
        };
    }

    public void method_5749(@NotNull class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.hiveManager.load(compoundTag);
        if (compoundTag.method_10545(NBT_JELLY_COUNT)) {
            this.setJellyCount(compoundTag.method_10550(NBT_JELLY_COUNT));
        }
        if (compoundTag.method_10545(NBT_HOST_TYPE)) {
            String resourceLocationString = compoundTag.method_10558(NBT_HOST_TYPE);
            class_2960 resourceLocation = class_2960.method_60654((String)resourceLocationString);
            Optional entityTypeHolderOptional = class_7923.field_41177.method_55841(resourceLocation);
            entityTypeHolderOptional.ifPresent($ -> {
                this.hostTypeOption = Option.some((Object)((class_1299)class_7923.field_41177.method_10223(resourceLocation)));
            });
        }
    }

    public void method_5652(@NotNull class_2487 compoundTag) {
        super.method_5652(compoundTag);
        this.hiveManager.save(compoundTag);
        compoundTag.method_10569(NBT_JELLY_COUNT, this.getJellyCount());
        this.hostTypeOption.ifSome(hostType -> {
            class_2960 resourceLocation = class_7923.field_41177.method_10221((Object)((class_1299)this.hostTypeOption.unwrap()));
            compoundTag.method_10582(NBT_HOST_TYPE, resourceLocation.toString());
        });
    }

    public GeneManager getGeneManager() {
        return ((GeneCarrier)((Object)this)).getOrCreateGeneManager();
    }

    public HiveManager getHiveManager() {
        return this.hiveManager;
    }

    public Option<class_1299<?>> getHostType() {
        return this.hostTypeOption;
    }

    public int getLastHurtTimeInTicks() {
        return this.lastHurtTimeInTicks;
    }

    @Nullable
    public Integer getMaxJellyToGrowth() {
        return null;
    }

    public MovementAnalyzer getMovementAnalyzer() {
        return this.movementAnalyzer;
    }

    public VibrationSystemManager getVibrationSystemManager() {
        return this.vibrationSystemManager;
    }

    public void setHostType(class_1299<?> hostType) {
        this.hostTypeOption = Option.some(hostType);
    }

    public void applyDynamicAttributes(AVPConfig.StatsConfigs.AdvancedStats config) {
        if (this.isAberrant()) {
            this.applyAttributes(config, AVP.config.statsConfigs.ABERRANT_STATS_MULTIPLIER);
        } else if (this.isIrradiated()) {
            this.applyAttributes(config, AVP.config.statsConfigs.IRRADIATED_STATS_MULTIPLIER);
        }
    }

    private void applyAttributes(AVPConfig.StatsConfigs.AdvancedStats config, float scaleFactor) {
        this.setAttribute((class_6880<class_1320>)class_5134.field_23716, config.health * scaleFactor);
        this.setAttribute((class_6880<class_1320>)class_5134.field_23721, config.attackDamage * scaleFactor);
        this.setAttribute((class_6880<class_1320>)class_5134.field_23724, config.armor * scaleFactor);
        this.setAttribute((class_6880<class_1320>)class_5134.field_23725, config.armorToughness * scaleFactor);
    }

    private void setAttribute(class_6880<class_1320> attribute, float value) {
        class_1324 instance = this.method_5996(attribute);
        if (instance != null) {
            instance.method_6192((double)value);
        }
    }

    public static class_5132.class_5133 applyFrom(AVPConfig.StatsConfigs.AdvancedStats config, class_5132.class_5133 builder) {
        builder.method_26868(class_5134.field_23724, (double)config.armor);
        builder.method_26868(class_5134.field_23725, (double)config.armorToughness);
        builder.method_26868(class_5134.field_23721, (double)config.attackDamage);
        builder.method_26868(class_5134.field_23717, (double)config.followRange);
        builder.method_26868(class_5134.field_23718, (double)config.knockbackResistance);
        builder.method_26868(class_5134.field_23716, (double)config.health);
        builder.method_26868(class_5134.field_23719, (double)config.moveSpeed);
        builder.method_26868(class_5134.field_23728, (double)0.1f);
        return builder;
    }
}

