/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.entity.living.alien.xenomorph.boiler.Boiler;
import com.alien.common.model.lifecycle.growth.GrowthStage;
import com.alien.common.registry.GrowthStageRegistry;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.avp.common.util.AVPEntityTransitionUtil;
import com.lib.common.gameplay.NBTSerializable;
import com.lib.common.gameplay.entity.manager.GeneContainer;
import com.lib.common.gameplay.gene.GeneOperationType;
import com.lib.common.gameplay.gene.Genes;
import com.lib.common.model.GeneCarrier;
import com.lib.common.model.GeneDecayLevelType;
import com.lib.common.util.GeneIntegrityUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;

public class GrowthManager
implements NBTSerializable {
    private static final String GROWTH_TIME_IN_TICKS_TAG_KEY = "growthTimeInTicks";
    private static final Set<String> TRANSITION_NBT_KEY_BLACKLIST = (Set)class_156.method_656(() -> {
        HashSet<String> set = new HashSet<String>(AVPEntityTransitionUtil.DEFAULT_NBT_KEY_BLACKLIST);
        set.add(GROWTH_TIME_IN_TICKS_TAG_KEY);
        return set;
    });
    private final Alien entity;
    @Nullable
    private final Consumer<class_1297> onGrowUpCallback;
    private boolean growOverTime;
    private int growthTimeInTicks;
    private int growthRetryTimeInTicks = 0;
    private boolean readyToGrow;

    public GrowthManager(Alien entity) {
        this(entity, null);
    }

    public GrowthManager(Alien entity, @Nullable Consumer<class_1297> onGrowUpCallback) {
        this.entity = entity;
        this.onGrowUpCallback = onGrowUpCallback;
        this.growOverTime = true;
        this.readyToGrow = false;
    }

    public void tick() {
        boolean canBypassGrowthTime;
        if (this.entity.method_37908().field_9236 || this.canNeverGrow()) {
            return;
        }
        GrowthStage growthStage = this.getNextGrowthStage();
        if (growthStage == null) {
            return;
        }
        boolean bl = canBypassGrowthTime = this.entity.getMaxJellyToGrowth() != null && this.entity.getJellyCount() >= this.entity.getMaxJellyToGrowth();
        if (canBypassGrowthTime) {
            this.readyToGrow = true;
        } else if (this.growOverTime) {
            this.growOverTime();
        }
        if (!this.readyToGrow) {
            return;
        }
        this.growthRetryTimeInTicks = Math.max(this.growthRetryTimeInTicks - 1, 0);
        if (this.growthRetryTimeInTicks > 0) {
            return;
        }
        GrowthResult growthResult = this.grow();
        Objects.requireNonNull(growthResult);
        GrowthResult growthResult2 = growthResult;
        int n = 0;
        block0 : switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GrowthResult.AlreadyFullyGrown.class, GrowthResult.CanNotGrow.class, GrowthResult.Success.class, GrowthResult.FailedTransitionResult.class}, (Object)growthResult2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                GrowthResult.AlreadyFullyGrown $ = (GrowthResult.AlreadyFullyGrown)growthResult2;
                break;
            }
            case 1: {
                GrowthResult.CanNotGrow $ = (GrowthResult.CanNotGrow)growthResult2;
                break;
            }
            case 2: {
                GrowthResult.Success $ = (GrowthResult.Success)growthResult2;
                break;
            }
            case 3: {
                GrowthResult.FailedTransitionResult failedTransitionResult = (GrowthResult.FailedTransitionResult)growthResult2;
                AVPEntityTransitionUtil.EntityTransitionResult entityTransitionResult = failedTransitionResult.result;
                Objects.requireNonNull(entityTransitionResult);
                AVPEntityTransitionUtil.EntityTransitionResult entityTransitionResult2 = entityTransitionResult;
                int n2 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AVPEntityTransitionUtil.EntityTransitionResult.ClientSide.class, AVPEntityTransitionUtil.EntityTransitionResult.EntityCreation.class, AVPEntityTransitionUtil.EntityTransitionResult.Obstructed.class, AVPEntityTransitionUtil.EntityTransitionResult.Success.class}, (Object)entityTransitionResult2, n2)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        AVPEntityTransitionUtil.EntityTransitionResult.ClientSide $1 = (AVPEntityTransitionUtil.EntityTransitionResult.ClientSide)entityTransitionResult2;
                        break block0;
                    }
                    case 1: {
                        AVPEntityTransitionUtil.EntityTransitionResult.EntityCreation $1 = (AVPEntityTransitionUtil.EntityTransitionResult.EntityCreation)entityTransitionResult2;
                        break block0;
                    }
                    case 2: {
                        AVPEntityTransitionUtil.EntityTransitionResult.Obstructed $1 = (AVPEntityTransitionUtil.EntityTransitionResult.Obstructed)entityTransitionResult2;
                        this.growthRetryTimeInTicks = 200;
                        break block0;
                    }
                    case 3: 
                }
                AVPEntityTransitionUtil.EntityTransitionResult.Success success = (AVPEntityTransitionUtil.EntityTransitionResult.Success)entityTransitionResult2;
            }
        }
    }

    @Nullable
    private GrowthStage getNextGrowthStage() {
        class_1299 hostType = (class_1299)this.entity.getHostType().unwrapOr(null);
        return GrowthStageRegistry.getOrNull(hostType, this.entity.method_5864());
    }

    private void growOverTime() {
        float growthTimeReductionMultiplier;
        ++this.growthTimeInTicks;
        GrowthStage growthStage = this.getNextGrowthStage();
        if (growthStage == null) {
            return;
        }
        int requiredGrowthTimeInTicks = growthStage.growthTimeInTicks();
        if ((float)this.growthTimeInTicks < (float)requiredGrowthTimeInTicks * (growthTimeReductionMultiplier = 1.0f)) {
            return;
        }
        this.readyToGrow = true;
    }

    public GrowthResult grow() {
        class_1297 nextForm;
        AVPEntityTransitionUtil.EntityTransitionResult transitionResult;
        this.growthTimeInTicks = 0;
        GrowthStage growthStage = this.getNextGrowthStage();
        if (growthStage == null) {
            return GrowthResult.AlreadyFullyGrown.INSTANCE;
        }
        if (this.canNeverGrow()) {
            return GrowthResult.CanNotGrow.INSTANCE;
        }
        Object nextFormType = growthStage.to();
        boolean canBecomeBoiler = this.canBecomeBoiler((class_1299<?>)nextFormType);
        if (canBecomeBoiler) {
            nextFormType = Boiler.getType(this.entity.getVariant());
        }
        AVPEntityTransitionUtil.EntityTransitionResult entityTransitionResult = transitionResult = AVPEntityTransitionUtil.transitionInto((class_1297)this.entity, nextFormType, TRANSITION_NBT_KEY_BLACKLIST);
        Objects.requireNonNull(entityTransitionResult);
        AVPEntityTransitionUtil.EntityTransitionResult entityTransitionResult2 = entityTransitionResult;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AVPEntityTransitionUtil.EntityTransitionResult.ClientSide.class, AVPEntityTransitionUtil.EntityTransitionResult.EntityCreation.class, AVPEntityTransitionUtil.EntityTransitionResult.Obstructed.class, AVPEntityTransitionUtil.EntityTransitionResult.Success.class}, (Object)entityTransitionResult2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                AVPEntityTransitionUtil.EntityTransitionResult.ClientSide ignored = (AVPEntityTransitionUtil.EntityTransitionResult.ClientSide)entityTransitionResult2;
                class_1297 class_12972 = null;
                break;
            }
            case 1: {
                AVPEntityTransitionUtil.EntityTransitionResult.EntityCreation ignored = (AVPEntityTransitionUtil.EntityTransitionResult.EntityCreation)entityTransitionResult2;
                class_1297 class_12972 = null;
                break;
            }
            case 2: {
                AVPEntityTransitionUtil.EntityTransitionResult.Obstructed ignored = (AVPEntityTransitionUtil.EntityTransitionResult.Obstructed)entityTransitionResult2;
                class_1297 class_12972 = null;
                break;
            }
            case 3: {
                AVPEntityTransitionUtil.EntityTransitionResult.Success success = (AVPEntityTransitionUtil.EntityTransitionResult.Success)entityTransitionResult2;
                class_1297 class_12972 = nextForm = (class_1297)success.newEntity();
            }
        }
        if (nextForm == null) {
            return new GrowthResult.FailedTransitionResult(transitionResult);
        }
        if (nextForm instanceof Alien) {
            Alien alien = (Alien)nextForm;
            int jellyCountToSubtract = this.entity.getMaxJellyToGrowth() == null ? 0 : this.entity.getMaxJellyToGrowth();
            alien.setJellyCount(this.entity.getJellyCount() - jellyCountToSubtract);
        }
        if (this.onGrowUpCallback != null) {
            this.onGrowUpCallback.accept(nextForm);
        }
        return new GrowthResult.Success(nextForm);
    }

    private boolean canNeverGrow() {
        return this.entity.isPoisoned() || this.entity.isIrradiated();
    }

    private boolean canBecomeBoiler(class_1299<?> nextFormType) {
        if (!this.isProperTransition(nextFormType)) {
            return false;
        }
        return this.shouldBecomeBoilerFromGeneDecay() || this.shouldBecomeBoilerFromAcidVolatility();
    }

    private boolean isProperTransition(class_1299<?> nextFormType) {
        boolean isCurrentlyAdolescent = this.entity.method_5864().method_20210(AVPEntityTypeTags.ADOLESCENTS);
        boolean willGrowIntoAdult = nextFormType.method_20210(AVPEntityTypeTags.XENOMORPHS);
        return isCurrentlyAdolescent && willGrowIntoAdult;
    }

    private boolean shouldBecomeBoilerFromAcidVolatility() {
        GeneContainer geneContainer = this.entity.getGeneManager().getGeneContainer();
        double additiveAcidVolatility = geneContainer.getActiveGeneMap().getValue(Genes.ACID_VOLATILITY, GeneOperationType.ADDITIVE);
        double multiplicativeAcidVolatility = geneContainer.getActiveGeneMap().getValue(Genes.ACID_VOLATILITY, GeneOperationType.MULTIPLICATIVE);
        double totalAcidVolatility = additiveAcidVolatility + multiplicativeAcidVolatility;
        return this.entity.method_59922().method_43058() < totalAcidVolatility;
    }

    private boolean shouldBecomeBoilerFromGeneDecay() {
        GeneCarrier geneCarrier = (GeneCarrier)((Object)this.entity);
        GeneDecayLevelType geneDecayLevel = GeneIntegrityUtil.getGeneDecayLevel(geneCarrier);
        return switch (geneDecayLevel) {
            default -> throw new MatchException(null, null);
            case GeneDecayLevelType.FATAL -> true;
            case GeneDecayLevelType.STABLE, GeneDecayLevelType.UNSTABLE -> false;
            case GeneDecayLevelType.VOLATILE -> {
                double totalGeneIntegrity = Math.abs(GeneIntegrityUtil.getTotalGeneticIntegrity(geneCarrier));
                double chance = totalGeneIntegrity - Math.floor(totalGeneIntegrity);
                if (this.entity.method_59922().method_43058() < chance) {
                    yield true;
                }
                yield false;
            }
        };
    }

    @Override
    public void load(class_2487 compoundTag) {
        if (compoundTag.method_10545(GROWTH_TIME_IN_TICKS_TAG_KEY)) {
            this.growthTimeInTicks = compoundTag.method_10550(GROWTH_TIME_IN_TICKS_TAG_KEY);
        }
    }

    @Override
    public void save(class_2487 compoundTag) {
        compoundTag.method_10569(GROWTH_TIME_IN_TICKS_TAG_KEY, this.growthTimeInTicks);
    }

    public GrowthManager setGrowOverTime(boolean growOverTime) {
        this.growOverTime = growOverTime;
        return this;
    }

    public static sealed interface GrowthResult {

        public record Success(class_1297 newEntity) implements GrowthResult
        {
        }

        public record FailedTransitionResult(AVPEntityTransitionUtil.EntityTransitionResult result) implements GrowthResult
        {
        }

        public static enum CanNotGrow implements GrowthResult
        {
            INSTANCE;

        }

        public static enum AlreadyFullyGrown implements GrowthResult
        {
            INSTANCE;

        }
    }
}

