/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien;

import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.level.gameevent.listener.ResinSpreadListener;
import com.alien.common.model.alien.variant.AlienVariantType;
import com.alien.common.model.resin.ReadableResinData;
import com.alien.common.model.resin.ResinData;
import com.avp.AVP;
import com.just.core.functional.option.Option;
import com.lib.common.gameplay.NBTSerializable;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.function.BiConsumer;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5709;
import net.minecraft.class_5714;
import net.minecraft.class_5715;
import net.minecraft.class_5716;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ResinManager
implements class_5714.class_8513<ResinSpreadListener>,
NBTSerializable {
    private static final String NBT_RESIN_DATA = "resinData";
    private final Alien alien;
    @Nullable
    private final ReadableResinData baseResinData;
    private final class_5715<ResinSpreadListener> dynamicResinSpreadListener;
    private final ResinSpreadListener resinSpreadListener;
    @Nullable
    private ResinData resinData;
    private int ticksSinceLastResinProduction = 0;
    private int ticksSinceAttemptedNodePlacement = 0;

    public ResinManager(Alien alien, @Nullable ResinData resinData) {
        this.alien = alien;
        this.baseResinData = resinData;
        this.resinData = resinData;
        class_5709 positionSource = new class_5709((class_1297)alien, 0.0f);
        ResinSpreadListener.SpreaderType.Entity spreadType = new ResinSpreadListener.SpreaderType.Entity((class_1297)alien);
        this.resinSpreadListener = new ResinSpreadListener((class_5716)positionSource, spreadType);
        this.dynamicResinSpreadListener = new class_5715((class_5714)this.resinSpreadListener);
    }

    @NotNull
    public ResinSpreadListener getListener() {
        return this.resinSpreadListener;
    }

    public void tick() {
        class_1937 level = this.alien.method_37908();
        if (level.field_9236 || this.baseResinData == null || this.resinData == null) {
            return;
        }
        ++this.ticksSinceLastResinProduction;
        this.ticksSinceAttemptedNodePlacement = Math.max(0, this.ticksSinceAttemptedNodePlacement - 1);
        if (this.ticksSinceLastResinProduction < this.resinData.tickRate()) {
            return;
        }
        int factor = this.resinData.tickRate() == 0 ? 0 : this.ticksSinceLastResinProduction / this.resinData.tickRate();
        int accumulatedResin = factor * this.resinData.resinPerTick();
        this.resinData.addResin(accumulatedResin);
        this.ticksSinceLastResinProduction = 0;
        if (this.resinData.resin() < this.resinData.resinMax() || this.ticksSinceAttemptedNodePlacement > 0 || !this.canSpreadResinAtAlienPosition()) {
            return;
        }
        AlienVariantType alienVariantType = AlienVariantTypes.getFor(this.alien);
        this.alien.method_32876(alienVariantType.resinSpreadEvent().getHolder());
        if (this.resinData.resin() >= this.resinData.resinMax()) {
            Option<class_2338> suitableResinNodeBlockPosOption = this.findSuitableResinNodeBlockPos(level, alienVariantType.resinReplaceableTag());
            if (suitableResinNodeBlockPosOption.isNone()) {
                this.ticksSinceAttemptedNodePlacement = 200;
                return;
            }
            class_2680 resinNodeBlockState = alienVariantType.resinNode().get().method_9564();
            this.alien.method_37908().method_8501((class_2338)suitableResinNodeBlockPosOption.unwrap(), resinNodeBlockState);
        }
    }

    private boolean canSpreadResinAtAlienPosition() {
        return this.alien.method_37908().method_8314(class_1944.field_9284, this.alien.method_24515()) == 0 && this.alien.method_5968() == null && !this.alien.method_5869() && this.alien.field_6012 > this.alien.getLastHurtTimeInTicks() + 200 && this.alien.getHiveManager().hive().filter(hive -> !hive.isAngry() && hive.getSpaceManager().isEntityWithinHive((class_1297)this.alien)).isSome();
    }

    private Option<class_2338> findSuitableResinNodeBlockPos(class_1937 level, class_6862<class_2248> replaceableTagKey) {
        class_2338 origin = this.alien.method_24515();
        class_2338 below = origin.method_10074();
        class_2680 belowState = level.method_8320(below);
        if (belowState.method_26164(replaceableTagKey)) {
            return Option.some((Object)below);
        }
        class_2338.class_2339 targetMutablePos = new class_2338.class_2339();
        class_2338.class_2339 belowTargetMutablePos = new class_2338.class_2339();
        int radius = 2;
        for (int r = 0; r <= radius; ++r) {
            for (int dx = -r; dx <= r; ++dx) {
                int dz = r - Math.abs(dx);
                for (int sign : new int[]{1, -1}) {
                    int actualDz = dz * sign;
                    for (int dy = -1; dy <= 1; ++dy) {
                        targetMutablePos.method_10103(origin.method_10263() + dx, origin.method_10264() + dy, origin.method_10260() + actualDz);
                        belowTargetMutablePos.method_10103(targetMutablePos.method_10263(), targetMutablePos.method_10264() - 1, targetMutablePos.method_10260());
                        class_2680 targetStateToReplace = level.method_8320((class_2338)targetMutablePos);
                        if (!targetStateToReplace.method_26215() && !targetStateToReplace.method_45474() || !level.method_8320((class_2338)belowTargetMutablePos).method_26216((class_1922)level, (class_2338)belowTargetMutablePos)) continue;
                        return Option.some((Object)targetMutablePos.method_10062());
                    }
                }
            }
        }
        return Option.none();
    }

    public void updateDynamicGameEventListener(@NotNull BiConsumer<class_5715<?>, class_3218> biConsumer) {
        class_1937 class_19372 = this.alien.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            biConsumer.accept(this.dynamicResinSpreadListener, serverLevel);
        }
    }

    @Nullable
    public ReadableResinData baseResinData() {
        return this.baseResinData;
    }

    @Nullable
    public ResinData resinData() {
        return this.resinData;
    }

    @Override
    public void load(class_2487 compoundTag) {
        if (compoundTag.method_10545(NBT_RESIN_DATA)) {
            ResinData.CODEC.parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)compoundTag.method_10562(NBT_RESIN_DATA))).resultOrPartial(arg_0 -> ((Logger)AVP.LOGGER).error(arg_0)).ifPresent(resinData -> {
                this.resinData = resinData;
            });
        }
    }

    @Override
    public void save(class_2487 compoundTag) {
        if (this.resinData != null) {
            ResinData.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.resinData).resultOrPartial(arg_0 -> ((Logger)AVP.LOGGER).error(arg_0)).ifPresent(tag -> compoundTag.method_10566(NBT_RESIN_DATA, tag));
        }
    }
}

