/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.ovomorph;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.entity.living.alien.ovomorph.HatchDesireManager;
import com.alien.common.gameplay.entity.living.alien.ovomorph.Ovomorph;
import com.alien.common.gameplay.entity.living.alien.parasite.facehugger.Facehugger;
import com.alien.common.model.alien.HatchState;
import com.avp.AVP;
import com.avp.common.registry.init.AVPDataKeys;
import com.avp.common.registry.init.AVPSoundEvents;
import com.lib.common.network.DataAccessor;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public class HatchManager {
    private final HatchDesireManager hatchDesireManager;
    private final Ovomorph ovomorph;
    private final DataAccessor<Integer> remainingHatchDurationInTicks;
    private final DataAccessor<Integer> remainingSpawnDelayInTicks;
    private final DataAccessor<Integer> spawnCount;

    public HatchManager(Ovomorph ovomorph, int hatchDurationInTicks, int spawnDelayInTicks) {
        this.hatchDesireManager = new HatchDesireManager(ovomorph);
        this.ovomorph = ovomorph;
        this.remainingHatchDurationInTicks = new DataAccessor<Integer>(ovomorph, AVPDataKeys.OVOMORPH_HATCH_DURATION_IN_TICKS);
        this.remainingHatchDurationInTicks.set(hatchDurationInTicks);
        this.remainingSpawnDelayInTicks = new DataAccessor<Integer>(ovomorph, AVPDataKeys.OVOMORPH_REMAINING_SPAWN_DELAY_IN_TICKS);
        this.remainingSpawnDelayInTicks.set(spawnDelayInTicks);
        this.spawnCount = new DataAccessor<Integer>(ovomorph, AVPDataKeys.OVOMORPH_SPAWN_COUNT);
    }

    public void tick() {
        boolean canSpawnMoreFacehuggers;
        this.hatchDesireManager.tick();
        class_1937 level = this.ovomorph.method_37908();
        if (level.field_9236 || !this.ovomorph.method_5805() || this.ovomorph.method_29504()) {
            return;
        }
        if (this.isHatching()) {
            this.remainingHatchDurationInTicks.set(Math.max(this.remainingHatchDurationInTicks.get() - 1, 0));
        }
        if (!this.isReadyToSpawnFacehuggers()) {
            return;
        }
        this.ovomorph.setHatchState(HatchState.HATCHED);
        boolean bl = canSpawnMoreFacehuggers = this.spawnCount.get() < this.ovomorph.maxSpawnCount.get();
        if (!canSpawnMoreFacehuggers) {
            return;
        }
        this.remainingSpawnDelayInTicks.set(Math.max(this.remainingSpawnDelayInTicks.get() - 1, 0));
        if (this.remainingSpawnDelayInTicks.get() == 0) {
            this.spawnFacehugger(level);
            this.remainingSpawnDelayInTicks.reset();
            this.spawnCount.set(this.spawnCount.get() + 1);
        }
    }

    public boolean isReadyToSpawnFacehuggers() {
        return this.remainingHatchDurationInTicks.get() <= 0;
    }

    public boolean isHatching() {
        return this.ovomorph.getHatchState().contains((Object)HatchState.HATCHING);
    }

    public boolean isHatched() {
        return this.ovomorph.getHatchState().contains((Object)HatchState.HATCHED);
    }

    public void hatch() {
        if (this.isHatching() || this.isHatched()) {
            return;
        }
        this.ovomorph.setHatchState(HatchState.HATCHING);
        this.ovomorph.method_37908().method_43129(null, (class_1297)this.ovomorph, AVPSoundEvents.ENTITY_OVOMORPH_HATCH.get(), class_3419.field_15251, 1.0f, 1.0f);
    }

    public void restore() {
        this.spawnCount.reset();
        this.remainingHatchDurationInTicks.reset();
        this.remainingSpawnDelayInTicks.reset();
        this.ovomorph.setHatchState(Ovomorph.DEFAULT_HATCH_STATE);
    }

    public HatchDesireManager getHatchDesireManager() {
        return this.hatchDesireManager;
    }

    private void spawnFacehugger(class_1937 level) {
        class_1299<? extends Alien> facehuggerType = Facehugger.getType(this.ovomorph.getVariant(), this.ovomorph.isRoyal());
        if (facehuggerType == null) {
            AVP.LOGGER.warn("Failed to get a facehugger type for an ovomorph entity Ovomorph Variant: {}, IsRoyal: {}.", (Object)this.ovomorph.getVariant(), (Object)this.ovomorph.isRoyal());
            return;
        }
        Alien facehugger = (Alien)facehuggerType.method_5883(level);
        if (facehugger == null) {
            AVP.LOGGER.warn("Failed to create facehugger entity.");
            return;
        }
        this.ovomorph.getGeneManager().getGeneContainer().transfer(facehugger.getGeneManager().getGeneContainer(), false);
        class_2338 ovomorphAbovePos = this.ovomorph.method_24515().method_10084();
        boolean ovomorphSuffocatingAboveCheck = this.ovomorph.method_37908().method_8320(ovomorphAbovePos).method_26228((class_1922)this.ovomorph.method_37908(), ovomorphAbovePos);
        double ovomorphYPos = ovomorphSuffocatingAboveCheck ? this.ovomorph.method_19538().field_1351 : this.ovomorph.method_19538().field_1351 + (double)this.ovomorph.method_17682();
        facehugger.method_5814(this.ovomorph.method_19538().field_1352, ovomorphYPos, this.ovomorph.method_19538().field_1350);
        facehugger.method_36456(this.ovomorph.method_36454());
        facehugger.method_36457(this.ovomorph.method_36455());
        facehugger.field_6283 = this.ovomorph.field_6283;
        facehugger.field_6241 = this.ovomorph.field_6241;
        facehugger.method_5971();
        if (!ovomorphSuffocatingAboveCheck) {
            facehugger.method_18800(class_3532.method_15344((class_5819)facehugger.method_59922(), (float)-0.5f, (float)0.5f), 0.7, class_3532.method_15344((class_5819)facehugger.method_59922(), (float)-0.5f, (float)0.5f));
        }
        level.method_8649((class_1297)facehugger);
    }
}

