/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.parasite;

import com.alien.common.gameplay.entity.living.alien.parasite.Parasite;
import com.alien.common.model.alien.FreeMob;
import com.alien.common.model.alien.Host;
import com.avp.common.registry.init.AVPDataKeys;
import com.avp.common.registry.key.AVPDamageTypeKeys;
import com.avp.common.util.AVPPredicates;
import com.lib.common.network.DataAccessor;
import java.util.Objects;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_2596;
import net.minecraft.class_2752;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class ParasiteAttachmentManager {
    private final Parasite parasite;
    private final DataAccessor<Integer> ticksAttachedToHost;

    public ParasiteAttachmentManager(Parasite parasite) {
        this.parasite = parasite;
        this.ticksAttachedToHost = new DataAccessor<Integer>(parasite, AVPDataKeys.PARASITE_TICKS_ATTACHED_TO_HOST);
    }

    public void tick() {
        if (this.parasite.method_37908().field_9236) {
            return;
        }
        class_1309 host = this.getHost();
        if (!this.isAttachedToHost()) {
            this.ticksAttachedToHost.reset();
            if (host instanceof class_1308) {
                class_1308 mob = (class_1308)host;
                ((FreeMob)mob).restoreFreedom();
            }
            return;
        }
        Objects.requireNonNull(host);
        if (!AVPPredicates.isHost((class_1297)host)) {
            this.parasite.method_18375();
            if (host instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)host;
                serverPlayer.field_13987.method_14364((class_2596)new class_2752((class_1297)host));
            }
            return;
        }
        if (this.parasite.method_29504()) {
            this.parasite.method_18375();
            return;
        }
        int effectTimeInTicks = 80;
        host.method_6092(new class_1293(class_1294.field_5919, effectTimeInTicks, 3, true, false, true));
        host.method_6092(new class_1293(class_1294.field_5909, effectTimeInTicks, 3, true, false, true));
        host.method_6092(new class_1293(class_1294.field_5901, effectTimeInTicks, 3, true, false, true));
        double falloffTimeInTicks = (host instanceof class_3222 ? 1.5 : 2.5) * 20.0 * 60.0;
        if (this.ticksAttachedToHost() < 200) {
            host.method_5643(this.parasite.method_48923().method_48795(AVPDamageTypeKeys.SMOTHERING), 0.01f);
        } else if ((double)this.ticksAttachedToHost() > falloffTimeInTicks) {
            this.parasite.method_5848();
            if (host instanceof class_3222) {
                class_3222 player = (class_3222)host;
                player.field_13987.method_14364((class_2596)new class_2752((class_1297)host));
            }
        } else {
            host.method_6092(new class_1293(class_1294.field_5911, effectTimeInTicks, 3, true, false, true));
            host.method_6092(new class_1293(class_1294.field_5909, effectTimeInTicks, 100, true, false, true));
            if (host instanceof class_1308) {
                class_1308 mob = (class_1308)host;
                ((FreeMob)mob).removeFreedom();
            }
            if (this.ticksAttachedToHost() >= 400 && this.parasite.isFertile.get().booleanValue()) {
                ((Host)host).implantEmbryo(this.parasite);
                this.parasite.isFertile.set(false);
            }
        }
        host.method_5855(host.method_5748());
        this.ticksAttachedToHost.set(this.ticksAttachedToHost.get() + 1);
    }

    public void restore() {
        this.parasite.isFertile.set(true);
    }

    @Nullable
    public class_1309 getHost() {
        class_1309 livingEntity;
        class_1297 class_12972 = this.parasite.method_5854();
        return class_12972 instanceof class_1309 ? (livingEntity = (class_1309)class_12972) : null;
    }

    public boolean isAttachedToHost() {
        return this.getHost() != null && this.parasite.method_5805();
    }

    public int ticksAttachedToHost() {
        return this.ticksAttachedToHost.get();
    }
}

