/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.xenomorph.drone;

import com.alien.common.gameplay.ai.CreateVentGoal;
import com.alien.common.gameplay.ai.DropOffEggGoal;
import com.alien.common.gameplay.ai.PickUpEggGoal;
import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.entity.living.alien.EggCarrier;
import com.alien.common.gameplay.entity.living.alien.xenomorph.EggPickupManager;
import com.alien.common.gameplay.entity.living.alien.xenomorph.Xenomorph;
import com.alien.common.gameplay.entity.living.alien.xenomorph.drone.DroneAnimationDispatcher;
import com.alien.common.model.alien.variant.AlienVariant;
import com.alien.common.model.resin.ResinData;
import com.alien.common.registry.init.AlienEntityTypes;
import com.avp.AVP;
import com.avp.common.gameplay.ai.goal.combat.LungeAtTargetGoal;
import com.avp.common.registry.init.AVPSoundEvents;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.avp.common.util.EntityUtil;
import java.util.function.BiConsumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_5132;
import net.minecraft.class_5715;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Drone
extends Xenomorph
implements EggCarrier {
    private final DroneAnimationDispatcher animationDispatcher = new DroneAnimationDispatcher(this);
    private final EggPickupManager eggPickupManager;

    public static class_5132.class_5133 createDroneAttributes() {
        return Drone.applyFrom(AVP.config.statsConfigs.DRONE_STATS, class_1588.method_26918());
    }

    public Drone(class_1299<? extends Drone> entityType, class_1937 level) {
        super((class_1299<? extends Xenomorph>)entityType, level);
        this.config = AVP.config.statsConfigs.DRONE_STATS;
        this.eggPickupManager = new EggPickupManager(this);
    }

    @Override
    @Nullable
    public class_1299<? extends Alien> getTypeForVariant(AlienVariant alienVariant) {
        return Drone.getType(alienVariant);
    }

    @Override
    @Nullable
    protected ResinData createResinData() {
        return new ResinData(0, 16, 1, AVP.config.statsConfigs.DRONE_STATS.nestTickrate);
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(3, (class_1352)new LungeAtTargetGoal((class_1308)this, 0.05f, 140, 6.0, 12.0).setOnLungeCallback(this::runLungeAnimation));
        this.field_6201.method_6277(4, new PickUpEggGoal<Drone>(this));
        this.field_6201.method_6277(5, new DropOffEggGoal<Drone>(this));
        this.field_6201.method_6277(6, (class_1352)new CreateVentGoal(this));
    }

    @Override
    public void method_5773() {
        super.method_5773();
        this.eggPickupManager.tick();
    }

    @Override
    protected boolean canEntityRideAlien(@NotNull class_1297 passenger) {
        return super.canEntityRideAlien(passenger) || passenger.method_5864().method_20210(AVPEntityTypeTags.OVOMORPHS);
    }

    protected void method_5865(@NotNull class_1297 passenger, @NotNull class_1297.class_4738 callback) {
        if (passenger.method_5864().method_20210(AVPEntityTypeTags.OVOMORPHS)) {
            class_243 relativePos = EntityUtil.getRelativePosition((class_1309)this, 0.0, 0.8, -1.0);
            callback.accept(passenger, relativePos.field_1352, relativePos.field_1351, relativePos.field_1350);
            return;
        }
        super.method_5865(passenger, callback);
    }

    @Override
    public void runAttackAnimations() {
        int attackType = this.field_5974.method_43051(0, 3);
        this.method_5783(AVPSoundEvents.ENTITY_XENOMORPH_ATTACK.get(), this.method_6107(), (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
        switch (attackType) {
            case 0: {
                this.animationDispatcher.rightClawAttack();
                break;
            }
            case 1: {
                this.animationDispatcher.biteAttack();
                break;
            }
            default: {
                this.animationDispatcher.tailAttack();
            }
        }
    }

    private void runLungeAnimation() {
        this.method_5783(AVPSoundEvents.ENTITY_XENOMORPH_LUNGE.get(), this.method_6107(), (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
        this.animationDispatcher.lunge();
    }

    @Override
    public void method_42147(@NotNull BiConsumer<class_5715<?>, class_3218> biConsumer) {
        super.method_42147(biConsumer);
        this.eggPickupManager.updateDynamicGameEventListener(biConsumer);
    }

    @Override
    protected float getHealthRegenPerSecond() {
        return AVP.config.statsConfigs.DRONE_STATS.healthRegenPerSecond;
    }

    @Override
    public Integer getMaxJellyToGrowth() {
        return 2;
    }

    @Override
    public EggPickupManager getEggPickupManager() {
        return this.eggPickupManager;
    }

    public DroneAnimationDispatcher getAnimationDispatcher() {
        return this.animationDispatcher;
    }

    public static class_1299<? extends Alien> getType(AlienVariant alienVariant) {
        return switch (alienVariant) {
            default -> throw new MatchException(null, null);
            case AlienVariant.NORMAL -> AlienEntityTypes.DRONE.get();
            case AlienVariant.NETHER -> AlienEntityTypes.NETHER_DRONE.get();
            case AlienVariant.ABERRANT -> AlienEntityTypes.ABERRANT_DRONE.get();
            case AlienVariant.IRRADIATED -> AlienEntityTypes.IRRADIATED_DRONE.get();
        };
    }
}

