/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.xenomorph.prowler;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.entity.living.alien.xenomorph.Xenomorph;
import com.alien.common.gameplay.entity.living.alien.xenomorph.prowler.ProwlerAnimationDispatcher;
import com.alien.common.model.alien.variant.AlienVariant;
import com.alien.common.model.resin.ResinData;
import com.alien.common.registry.init.AlienEntityTypes;
import com.avp.AVP;
import com.avp.common.gameplay.ai.goal.combat.LungeAtTargetGoal;
import com.avp.common.registry.init.AVPSoundEvents;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1352;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import net.minecraft.class_5132;
import org.jetbrains.annotations.Nullable;

public class Prowler
extends Xenomorph {
    private final ProwlerAnimationDispatcher animationDispatcher = new ProwlerAnimationDispatcher(this);

    public static class_5132.class_5133 createProwlerAttributes() {
        return Prowler.applyFrom(AVP.config.statsConfigs.PROWLER_STATS, class_1588.method_26918());
    }

    public Prowler(class_1299<? extends Prowler> entityType, class_1937 level) {
        super((class_1299<? extends Xenomorph>)entityType, level);
        this.config = AVP.config.statsConfigs.PROWLER_STATS;
    }

    @Override
    @Nullable
    public class_1299<? extends Alien> getTypeForVariant(AlienVariant alienVariant) {
        return Prowler.getType(alienVariant);
    }

    @Override
    @Nullable
    protected ResinData createResinData() {
        return new ResinData(0, 16, 1, AVP.config.statsConfigs.PROWLER_STATS.nestTickrate);
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(3, (class_1352)new LungeAtTargetGoal((class_1308)this, 0.05f, 140, 6.0, 12.0).setOnLungeCallback(this::runLungeAnimation));
    }

    @Override
    protected double getPursuitSpeedModifier() {
        return 1.2;
    }

    @Override
    public void runAttackAnimations() {
        int attackType = this.field_5974.method_43051(0, 3);
        this.method_5783(AVPSoundEvents.ENTITY_XENOMORPH_ATTACK.get(), this.method_6107(), (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
        switch (attackType) {
            case 0: {
                this.animationDispatcher.rightClawAttack();
                break;
            }
            case 1: {
                this.animationDispatcher.biteAttack();
                break;
            }
            default: {
                this.animationDispatcher.tailAttackQuad();
            }
        }
    }

    private void runLungeAnimation() {
        this.method_5783(AVPSoundEvents.ENTITY_XENOMORPH_LUNGE.get(), this.method_6107(), (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
        this.animationDispatcher.lunge();
    }

    @Override
    protected float getHealthRegenPerSecond() {
        return AVP.config.statsConfigs.PROWLER_STATS.healthRegenPerSecond;
    }

    @Override
    public Integer getMaxJellyToGrowth() {
        return 2;
    }

    public ProwlerAnimationDispatcher getAnimationDispatcher() {
        return this.animationDispatcher;
    }

    public static class_1299<? extends Alien> getType(AlienVariant alienVariant) {
        return switch (alienVariant) {
            default -> throw new MatchException(null, null);
            case AlienVariant.NORMAL -> AlienEntityTypes.PROWLER.get();
            case AlienVariant.NETHER -> AlienEntityTypes.NETHER_PROWLER.get();
            case AlienVariant.ABERRANT -> AlienEntityTypes.ABERRANT_PROWLER.get();
            case AlienVariant.IRRADIATED -> AlienEntityTypes.IRRADIATED_PROWLER.get();
        };
    }
}

