/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.xenomorph.queen;

import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.entity.living.alien.xenomorph.Xenomorph;
import com.alien.common.gameplay.entity.living.alien.xenomorph.drone.Drone;
import com.alien.common.gameplay.entity.living.alien.xenomorph.queen.OvipositorManager;
import com.alien.common.gameplay.entity.living.alien.xenomorph.queen.QueenAnimationDispatcher;
import com.alien.common.gameplay.level.saveddata.StrainLeakData;
import com.alien.common.model.alien.variant.AlienVariant;
import com.alien.common.model.resin.ResinData;
import com.alien.common.registry.init.AlienEntityTypes;
import com.avp.AVP;
import com.avp.common.gameplay.ai.goal.DigToTargetGoal;
import com.avp.common.gameplay.ai.goal.QueenLayEggGoal;
import com.avp.common.registry.init.AVPSoundEvents;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.avp.common.util.EntityUtil;
import com.avp.server.ServerLevelManagerAccessor;
import com.lib.common.util.PlayerUtil;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5425;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Queen
extends Xenomorph {
    private final QueenAnimationDispatcher animationDispatcher = new QueenAnimationDispatcher(this);
    private final OvipositorManager ovipositorManager = new OvipositorManager(this);

    public static class_5132.class_5133 createQueenAttributes() {
        return Queen.applyFrom(AVP.config.statsConfigs.QUEEN_STATS, class_1588.method_26918());
    }

    public Queen(class_1299<? extends Queen> entityType, class_1937 level) {
        super((class_1299<? extends Xenomorph>)entityType, level);
        this.config = AVP.config.statsConfigs.QUEEN_STATS;
    }

    @Override
    @Nullable
    public class_1299<? extends Alien> getTypeForVariant(AlienVariant alienVariant) {
        return Queen.getType(alienVariant);
    }

    @Override
    @Nullable
    protected ResinData createResinData() {
        return new ResinData(0, 128, 1, AVP.config.statsConfigs.QUEEN_STATS.nestTickrate);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        this.ovipositorManager.tick();
    }

    @Override
    protected boolean canEntityRideAlien(@NotNull class_1297 passenger) {
        return Objects.equals(passenger.method_5864(), AlienEntityTypes.OVIPOSITOR.get());
    }

    protected void method_5865(@NotNull class_1297 passenger, @NotNull class_1297.class_4738 callback) {
        if (passenger.method_5864() == AlienEntityTypes.OVIPOSITOR.get()) {
            class_243 relativePos = EntityUtil.getRelativePosition((class_1309)this, 3.0, 0.01, 5.25);
            callback.accept(passenger, relativePos.field_1352, relativePos.field_1351, relativePos.field_1350);
            return;
        }
        super.method_5865(passenger, callback);
    }

    @Override
    @Nullable
    public class_1315 method_5943(@NotNull class_5425 serverLevelAccessor, @NotNull class_1266 difficulty, @NotNull class_3730 spawnType, @Nullable class_1315 spawnGroupData) {
        if (spawnType == class_3730.field_16459) {
            this.applyNaturalSpawnEffects();
        }
        return super.method_5943(serverLevelAccessor, difficulty, spawnType, spawnGroupData);
    }

    private void applyNaturalSpawnEffects() {
        class_1937 level = this.method_37908();
        if (level.field_9236) {
            return;
        }
        this.alertPlayersOfSpawn();
        this.spawnGuards();
        this.resetQueenSpawnCooldown();
        StrainLeakData.getOrCreate(level).ifSome(strainLeakData -> strainLeakData.add(this.getVariant(), -1));
    }

    private void alertPlayersOfSpawn() {
        for (class_3222 player : PlayerUtil.getTrackingPlayers((class_1297)this)) {
            player.method_17356(AVPSoundEvents.ENTITY_QUEEN_SCREAM.get(), class_3419.field_15250, 1.0f, 1.0f);
            player.method_43496((class_2561)class_2561.method_43470((String)"A scream from the depths sends chills down your spine...").method_27695(new class_124[]{AlienVariantTypes.getFor(this).chatColor(), class_124.field_1056}));
        }
    }

    private void spawnGuards() {
        class_1299<? extends Alien> droneType = Drone.getType(this.getVariant());
        for (int i = 0; i < 4; ++i) {
            Alien drone = (Alien)droneType.method_47821((class_3218)this.method_37908(), this.method_24515(), class_3730.field_16459);
            if (drone == null) continue;
            drone.method_5971();
        }
    }

    private void resetQueenSpawnCooldown() {
        ((ServerLevelManagerAccessor)this.method_37908()).avp$getServerLevelManager().getQueenSpawnCooldown().reset();
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(5, (class_1352)new QueenLayEggGoal(this));
    }

    @Override
    protected void addDigToTargetGoal() {
        this.field_6201.method_6277(5, (class_1352)new DigToTargetGoal((class_1308)this, 32.0, 4, () -> !Objects.requireNonNull(this.ovipositorManager).hasOvipositor()));
    }

    @Override
    public float method_49476() {
        return 2.5f;
    }

    @Override
    @Nullable
    protected class_3414 method_5994() {
        return AVPSoundEvents.ENTITY_QUEEN_IDLE.get();
    }

    @Override
    @NotNull
    protected class_3414 method_6002() {
        return AVPSoundEvents.ENTITY_QUEEN_DEATH.get();
    }

    @Override
    @NotNull
    protected class_3414 method_6011(@NotNull class_1282 damageSource) {
        return AVPSoundEvents.ENTITY_QUEEN_HURT.get();
    }

    @Override
    protected float getHealthRegenPerSecond() {
        return AVP.config.statsConfigs.QUEEN_STATS.healthRegenPerSecond;
    }

    @Override
    public void runAttackAnimations() {
        int attackType = this.field_5974.method_43051(0, 3);
        this.method_5783(AVPSoundEvents.ENTITY_XENOMORPH_ATTACK.get(), this.method_6107(), (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
        switch (attackType) {
            case 0: {
                this.animationDispatcher.swipeDownAttack();
                break;
            }
            case 1: {
                this.animationDispatcher.backhandAttack();
                break;
            }
            default: {
                this.animationDispatcher.tailStrikeAttack();
            }
        }
    }

    @Override
    protected void method_6087(@NotNull class_1297 entity) {
        if (!this.ovipositorManager.hasOvipositor() || !entity.method_5864().method_20210(AVPEntityTypeTags.ALIENS)) {
            super.method_6087(entity);
        }
    }

    public boolean method_5675() {
        return false;
    }

    public boolean method_5810() {
        return false;
    }

    @Override
    public boolean method_5947() {
        return true;
    }

    public void method_5982() {
        super.method_5982();
    }

    @Override
    public Integer getMaxJellyToGrowth() {
        return null;
    }

    public QueenAnimationDispatcher getAnimationDispatcher() {
        return this.animationDispatcher;
    }

    public OvipositorManager getOvipositorManager() {
        return this.ovipositorManager;
    }

    @Override
    public void method_5749(@NotNull class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.ovipositorManager.load(compoundTag);
    }

    @Override
    public void method_5652(@NotNull class_2487 compoundTag) {
        super.method_5652(compoundTag);
        this.ovipositorManager.save(compoundTag);
    }

    public static class_1299<? extends Alien> getType(AlienVariant alienVariant) {
        return switch (alienVariant) {
            default -> throw new MatchException(null, null);
            case AlienVariant.NORMAL -> AlienEntityTypes.QUEEN.get();
            case AlienVariant.NETHER -> AlienEntityTypes.NETHER_QUEEN.get();
            case AlienVariant.ABERRANT -> AlienEntityTypes.ABERRANT_QUEEN.get();
            case AlienVariant.IRRADIATED -> AlienEntityTypes.IRRADIATED_QUEEN.get();
        };
    }
}

