/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.xenomorph.queen;

import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.entity.living.alien.xenomorph.queen.Queen;
import com.alien.common.gameplay.level.saveddata.HiveLevelData;
import com.alien.common.gameplay.level.saveddata.QueenSpawnChunkData;
import com.alien.common.gameplay.level.saveddata.StrainLeakData;
import com.alien.common.model.alien.variant.AlienVariantType;
import com.avp.server.ServerLevelManager;
import com.avp.server.ServerLevelManagerAccessor;
import com.just.core.functional.option.Option;
import java.util.Objects;
import net.minecraft.class_1299;
import net.minecraft.class_1317;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_5819;

public class QueenSpawning {
    private static final int MAX_OVERWORLD_Y_LEVEL = -24;
    public static final class_1317.class_4306<Queen> PREDICATE = (entityType, serverLevelAccessor, mobSpawnType, blockPos, randomSource) -> {
        class_3218 serverLevel = serverLevelAccessor.method_8410();
        ServerLevelManager serverLevelManager = ((ServerLevelManagerAccessor)serverLevel).avp$getServerLevelManager();
        if (serverLevelManager.getQueenSpawnCooldown().isActive()) {
            return false;
        }
        Option<QueenSpawnChunkData> queenSpawnChunkDataOption = QueenSpawnChunkData.getOrCreate((class_1937)serverLevel);
        boolean isChunkSpawnAvailable = queenSpawnChunkDataOption.isSomeAnd(queenSpawnChunkData -> !queenSpawnChunkData.isChunkBlacklisted(blockPos));
        if (!isChunkSpawnAvailable) {
            return false;
        }
        int maxYLevelForDimension = serverLevel.method_27983() == class_1937.field_25180 ? serverLevel.method_8597().comp_653() : -24;
        return blockPos.method_10264() <= maxYLevelForDimension && QueenSpawning.canStrainSpawnInLevel(serverLevel, (class_1299<Queen>)entityType) && QueenSpawning.checkSpawnRules((class_1299<? extends class_1588>)entityType, serverLevelAccessor, mobSpawnType, blockPos, randomSource);
    };

    private static boolean canStrainSpawnInLevel(class_3218 serverLevel, class_1299<Queen> entityType) {
        Option<StrainLeakData> strainLeakDataOption = StrainLeakData.getOrCreate((class_1937)serverLevel);
        Option<AlienVariantType> alienVariantTypeOption = AlienVariantTypes.getFor(entityType);
        return alienVariantTypeOption.isSomeAnd(alienVariantType -> strainLeakDataOption.isSomeAnd(strainLeakData -> strainLeakData.hasVariant(alienVariantType.variant())));
    }

    public static boolean checkSpawnRules(class_1299<? extends class_1588> entityType, class_5425 serverLevelAccessor, class_3730 mobSpawnType, class_2338 blockPos, class_5819 randomSource) {
        Option<AlienVariantType> alienVariantTypeOption = AlienVariantTypes.getFor(entityType);
        return class_1588.method_20680(entityType, (class_5425)serverLevelAccessor, (class_3730)mobSpawnType, (class_2338)blockPos, (class_5819)randomSource) && (Boolean)HiveLevelData.getOrCreate((class_1937)serverLevelAccessor.method_8410()).andThen(hiveLevelData -> hiveLevelData.findNearestHive(blockPos, hive -> alienVariantTypeOption.isSomeAnd(alienVariantType -> Objects.equals((Object)hive.getVariant(), (Object)alienVariantType.variant())))).match(nearestHive -> !nearestHive.getSpaceManager().isBlockPosWithinHiveBuffer(blockPos), () -> true) != false;
    }
}

