/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.xenomorph.warrior;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.entity.living.alien.xenomorph.Xenomorph;
import com.alien.common.gameplay.entity.living.alien.xenomorph.warrior.WarriorAnimationDispatcher;
import com.alien.common.model.alien.variant.AlienVariant;
import com.alien.common.model.resin.ResinData;
import com.alien.common.registry.init.AlienEntityTypes;
import com.avp.AVP;
import com.avp.common.gameplay.ai.goal.combat.LungeAtTargetGoal;
import com.avp.common.registry.init.AVPSoundEvents;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1352;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import net.minecraft.class_5132;
import org.jetbrains.annotations.Nullable;

public class Warrior
extends Xenomorph {
    private final WarriorAnimationDispatcher animationDispatcher = new WarriorAnimationDispatcher(this);

    public static class_5132.class_5133 createWarriorAttributes() {
        return Warrior.applyFrom(AVP.config.statsConfigs.WARRIOR_STATS, class_1588.method_26918());
    }

    public Warrior(class_1299<? extends Warrior> entityType, class_1937 level) {
        super((class_1299<? extends Xenomorph>)entityType, level);
        this.config = AVP.config.statsConfigs.WARRIOR_STATS;
    }

    @Override
    @Nullable
    public class_1299<? extends Alien> getTypeForVariant(AlienVariant alienVariant) {
        return Warrior.getType(alienVariant);
    }

    @Override
    protected float getHealthRegenPerSecond() {
        return AVP.config.statsConfigs.WARRIOR_STATS.healthRegenPerSecond;
    }

    @Override
    @Nullable
    protected ResinData createResinData() {
        return new ResinData(0, 32, 1, AVP.config.statsConfigs.WARRIOR_STATS.nestTickrate);
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(3, (class_1352)new LungeAtTargetGoal((class_1308)this, 0.1f, 100, 6.0, 15.0).setOnLungeCallback(this::runLungeAnimation));
    }

    @Override
    public void runAttackAnimations() {
        int attackType = this.field_5974.method_43051(0, 3);
        this.method_5783(AVPSoundEvents.ENTITY_XENOMORPH_ATTACK.get(), this.method_6107(), (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
        switch (attackType) {
            case 0: {
                this.animationDispatcher.rightClawAttack();
                break;
            }
            case 1: {
                this.animationDispatcher.biteAttack();
                break;
            }
            default: {
                this.animationDispatcher.tailAttack();
            }
        }
    }

    private void runLungeAnimation() {
        this.method_5783(AVPSoundEvents.ENTITY_XENOMORPH_LUNGE.get(), this.method_6107(), (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
        this.animationDispatcher.lunge();
    }

    @Override
    public Integer getMaxJellyToGrowth() {
        return 4;
    }

    public WarriorAnimationDispatcher getAnimationDispatcher() {
        return this.animationDispatcher;
    }

    public static class_1299<? extends Alien> getType(AlienVariant alienVariant) {
        return switch (alienVariant) {
            default -> throw new MatchException(null, null);
            case AlienVariant.NORMAL -> AlienEntityTypes.WARRIOR.get();
            case AlienVariant.NETHER -> AlienEntityTypes.NETHER_WARRIOR.get();
            case AlienVariant.ABERRANT -> AlienEntityTypes.ABERRANT_WARRIOR.get();
            case AlienVariant.IRRADIATED -> AlienEntityTypes.IRRADIATED_WARRIOR.get();
        };
    }
}

