/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.hive;

import com.alien.common.data.AlienAdvancements;
import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.hive.Hive;
import com.alien.common.model.alien.variant.AlienVariant;
import com.alien.common.model.alien.variant.AlienVariantType;
import com.alien.common.util.AlienPredicates;
import com.avp.AVP;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1259;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class HiveBossBarManager {
    public static final Map<AlienVariant, String> ALIEN_VARIANT_TO_TRANSLATABLE_STRING_MAP = Arrays.stream(AlienVariant.values()).collect(Collectors.toMap(Function.identity(), alienVariant -> "bossbar.avp.hive." + alienVariant.name().toLowerCase(Locale.US) + ".title"));
    private static final Map<AlienVariant, class_2561> ALIEN_VARIANT_TO_COMPONENT_NAME_MAP = ALIEN_VARIANT_TO_TRANSLATABLE_STRING_MAP.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> class_2561.method_43471((String)((String)entry.getValue()))));
    private static final Predicate<class_1299<?>> XENOMORPH_PREDICATE = entityType -> entityType.method_20210(AVPEntityTypeTags.XENOMORPHS);
    private final Hive hive;
    private final class_3213 bossEvent;
    private int maximumSeenXenomorphCount;

    public HiveBossBarManager(Hive hive) {
        this.bossEvent = (class_3213)new class_3213(ALIEN_VARIANT_TO_COMPONENT_NAME_MAP.get((Object)hive.getVariant()), class_1259.class_1260.field_5785, class_1259.class_1261.field_5795).method_5406(AVP.config.hiveConfigs.HIVE_DARKEN_SCREEN);
        this.hive = hive;
    }

    public void tick() {
        this.updateBossBarProgress();
        this.updateBossBarColor();
        this.updateBossBarTitle();
        this.updateTrackingPlayers();
    }

    private void updateBossBarProgress() {
        int loadedXenomorphCount = this.hive.getMembershipManager().getMembersMatching(XENOMORPH_PREDICATE).size();
        int currentReserveXenomorphCount = this.hive.getReserveManager().getCountMatching(XENOMORPH_PREDICATE);
        int totalXenomorphCount = loadedXenomorphCount + currentReserveXenomorphCount;
        this.maximumSeenXenomorphCount = Math.max(this.maximumSeenXenomorphCount, totalXenomorphCount);
        this.bossEvent.method_5408((float)totalXenomorphCount / (float)this.maximumSeenXenomorphCount);
    }

    private void updateBossBarColor() {
        AlienVariantType alienVariantType = AlienVariantTypes.getFor(this.hive.getVariant());
        this.bossEvent.method_5416(alienVariantType.bossBarColor());
    }

    private void updateBossBarTitle() {
        AlienVariant variant = this.hive.getVariant();
        class_2561 component = ALIEN_VARIANT_TO_COMPONENT_NAME_MAP.get((Object)variant);
        this.bossEvent.method_5413(component);
    }

    private void updateTrackingPlayers() {
        if (this.hive.ageInTicks() % 20 == 0) {
            this.removeNonTargetPlayers(this.bossEvent);
        }
        if (!this.hive.isAlive()) {
            this.bossEvent.method_14094();
        }
    }

    private void removeNonTargetPlayers(class_3213 bossEvent) {
        List<class_3222> playersToRemove = bossEvent.method_14092().stream().filter(player -> {
            if (!AlienPredicates.isValidTarget(this.hive.getVariant(), (class_1309)player)) {
                return true;
            }
            return !this.hive.getSpaceManager().isEntityWithinHive((class_1297)player) || !this.isPlayerInSameDimensionAsHive((class_3222)player);
        }).toList();
        playersToRemove.forEach(arg_0 -> ((class_3213)bossEvent).method_14089(arg_0));
    }

    private boolean isPlayerInSameDimensionAsHive(class_3222 player) {
        return Objects.equals(player.method_37908().method_8597(), this.hive.level().method_8597());
    }

    public void onHiveRemoved() {
        class_1937 level = this.hive.level();
        if (level.method_8407() != class_1267.field_5801 && level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            serverLevel.method_18456().stream().filter(player -> this.hive.getSpaceManager().isEntityWithinHive((class_1297)player)).forEach(AlienAdvancements.KILL_A_HIVE::grant);
        }
        this.bossEvent.method_14094();
    }

    public void trackPlayer(class_3222 player) {
        this.bossEvent.method_14088(player);
    }

    public boolean isTrackingPlayers() {
        return !this.bossEvent.method_14092().isEmpty();
    }
}

