/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.hive;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.hive.Hive;
import com.avp.AVP;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;

public class HiveDebugManager {
    private final Hive hive;

    public HiveDebugManager(Hive hive) {
        this.hive = hive;
    }

    public void tick() {
        HiveDebugManager debugManager = this.hive.getDebugManager();
        if (debugManager.isDebugEnabled()) {
            this.runDebugRoutines();
        }
    }

    public void onHiveRemoved() {
    }

    private void runDebugRoutines() {
        class_1293 effect;
        HiveDebugManager debugManager = this.hive.getDebugManager();
        Alien hiveLeader = this.hive.getLeadershipManager().getLeaderOrNull();
        if (hiveLeader != null && debugManager.isDebugLeaderHighlightEnabled() && this.hive.ageInTicks() % 20 == 0) {
            effect = new class_1293(class_1294.field_5912, 40, 3, true, false, true);
            hiveLeader.method_6092(effect);
        }
        if (debugManager.isDebugHiveMemberHighlightEnabled()) {
            effect = new class_1293(class_1294.field_5912, 40, 3, true, false, true);
            this.hive.getMembershipManager().getLoadedMembers().forEach(entity -> {
                if (entity instanceof class_1309) {
                    class_1309 livingEntity = (class_1309)entity;
                    livingEntity.method_6092(effect);
                }
            });
        }
    }

    public boolean isDebugEnabled() {
        return AVP.config.hiveConfigs.HIVE_DEBUG_ENABLED;
    }

    public boolean isDebugHiveMemberHighlightEnabled() {
        return AVP.config.hiveConfigs.HIVE_DEBUG_HIGHLIGHT_ALL_MEMBERS;
    }

    public boolean isDebugLeaderHighlightEnabled() {
        return AVP.config.hiveConfigs.HIVE_DEBUG_HIGHLIGHT_LEADER;
    }
}

