/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.hive.ai.task.impl.balance;

import com.alien.common.gameplay.entity.living.alien.xenomorph.Xenomorph;
import com.alien.common.gameplay.hive.Hive;
import com.alien.common.gameplay.hive.ai.task.impl.balance.BalanceHiveTask;
import com.alien.common.gameplay.hive.membership.HiveReserveManager;
import com.alien.common.model.hive.HiveMemberData;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_3218;

public class BalanceAveragingHiveTask
extends BalanceHiveTask {
    private final Supplier<class_1299<?>> baseUnitTypeSupplier;
    private final Supplier<class_1299<?>> desiredUnitTypeSupplier;

    public BalanceAveragingHiveTask(Hive hive, Supplier<class_1299<?>> baseUnitTypeSupplier, Supplier<class_1299<?>> desiredUnitTypeSupplier) {
        super(hive);
        this.baseUnitTypeSupplier = baseUnitTypeSupplier;
        this.desiredUnitTypeSupplier = desiredUnitTypeSupplier;
    }

    @Override
    public void run() {
        this.balanceReserveUnits();
        this.balanceLoadedUnits();
    }

    private void balanceReserveUnits() {
        int currentDesiredUnitCount;
        HiveReserveManager reserveManager = this.hive.getReserveManager();
        class_1299<?> baseUnitType = this.baseUnitTypeSupplier.get();
        class_1299<?> desiredUnitType = this.desiredUnitTypeSupplier.get();
        int baseUnitCount = reserveManager.getCount(baseUnitType);
        int desiredUnitCount = this.computeDesiredUnitCount(baseUnitCount, currentDesiredUnitCount = reserveManager.getCount(desiredUnitType));
        if (desiredUnitCount == 0) {
            return;
        }
        reserveManager.add(baseUnitType, -desiredUnitCount);
        reserveManager.add(desiredUnitType, desiredUnitCount);
    }

    private void balanceLoadedUnits() {
        List desiredUnits;
        Map<class_1299<?>, List<Map.Entry<UUID, HiveMemberData>>> membersByType = this.hive.getMembershipManager().getMembersByEntityType();
        class_1299<?> baseEntityType = this.baseUnitTypeSupplier.get();
        class_1299<?> desiredEntityType = this.desiredUnitTypeSupplier.get();
        List baseUnits = membersByType.getOrDefault(baseEntityType, List.of());
        int baseUnitCount = baseUnits.size();
        int desiredUnitCount = this.computeDesiredUnitCount(baseUnitCount, (desiredUnits = membersByType.getOrDefault(desiredEntityType, List.of())).size());
        if (desiredUnitCount == 0) {
            return;
        }
        int offset = Math.max(baseUnitCount - desiredUnitCount, 0);
        baseUnits.stream().sorted(Comparator.comparingInt(a -> ((HiveMemberData)a.getValue()).lastSeenTimestampInTicks())).toList().subList(offset, baseUnitCount).forEach(entry -> {
            class_1297 baseUnit = ((class_3218)this.hive.level()).method_14190((UUID)entry.getKey());
            if (!(baseUnit instanceof Xenomorph)) {
                return;
            }
            Xenomorph xenomorph = (Xenomorph)baseUnit;
            this.growXenomorph(xenomorph);
        });
    }

    private int computeDesiredUnitCount(int baseUnitCount, int desiredUnitCount) {
        return Math.max(0, (baseUnitCount - desiredUnitCount) / 2);
    }
}

