/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.hive.membership;

import com.alien.common.gameplay.hive.Hive;
import com.alien.common.gameplay.hive.membership.HiveMembershipCache;
import com.alien.common.model.hive.HiveMemberData;
import com.avp.AVP;
import com.just.core.functional.option.Option;
import com.lib.common.gameplay.NBTSerializable;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class HiveMembershipManager
implements NBTSerializable {
    private static final String HIVE_MEMBER_DATA_KEY = "HiveMemberData";
    private static final int MEMBERSHIP_PURGE_FREQUENCY = 1200;
    private final Hive hive;
    private final HiveMembershipCache hiveMembershipCache;

    public HiveMembershipManager(Hive hive) {
        this.hive = hive;
        this.hiveMembershipCache = new HiveMembershipCache();
    }

    public void tick() {
        if (this.hive.ageInTicks() % 1200 == 0) {
            this.purgeUnresponsiveHiveMembers();
        }
    }

    private void purgeUnresponsiveHiveMembers() {
        this.hiveMembershipCache.removeIf(hiveMemberEntry -> {
            HiveMemberData hiveMemberData = (HiveMemberData)hiveMemberEntry.getValue();
            int lastSeenTimestampInTicks = hiveMemberData.lastSeenTimestampInTicks();
            class_2338 lastSeenPos = hiveMemberData.lastSeenPos();
            boolean isLastSeenPosLoaded = this.hive.level().method_8477(lastSeenPos);
            if (!isLastSeenPosLoaded) {
                return true;
            }
            return this.hive.ageInTicks() - lastSeenTimestampInTicks > 3600;
        });
    }

    public void clearMembers() {
        this.hiveMembershipCache.clear();
    }

    public void addMember(class_1297 entity) {
        class_2960 resourceLocation = class_7923.field_41177.method_10221((Object)entity.method_5864());
        HiveMemberData hiveMemberData = new HiveMemberData(resourceLocation, entity.method_24515(), this.hive.ageInTicks());
        this.addMember(entity.method_5667(), hiveMemberData);
    }

    public void addMember(UUID entityUUID, HiveMemberData hiveMemberData) {
        this.hiveMembershipCache.add(entityUUID, hiveMemberData);
    }

    public boolean isMember(class_1297 entity) {
        return this.isMember(entity.method_5667());
    }

    public boolean isMember(UUID uuid) {
        return this.hiveMembershipCache.has(uuid);
    }

    public void removeMember(class_1297 entity) {
        this.hiveMembershipCache.remove(entity.method_5667());
    }

    public Set<UUID> getMemberUUIDs() {
        return this.hiveMembershipCache.streamEntries().map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public int getMemberCount() {
        return this.hiveMembershipCache.size();
    }

    public List<class_1297> getLoadedMembers() {
        class_1937 level = this.hive.level();
        return level.field_9236 ? List.of() : this.hiveMembershipCache.streamEntries().map(Map.Entry::getKey).map(arg_0 -> ((class_3218)((class_3218)level)).method_14190(arg_0)).filter(Objects::nonNull).toList();
    }

    @NotNull
    public Option<HiveMemberData> getMemberData(@Nullable class_1297 entity) {
        if (entity == null) {
            return Option.none();
        }
        return this.getMemberData(entity.method_5667());
    }

    @NotNull
    public Option<HiveMemberData> getMemberData(@Nullable UUID uuid) {
        if (uuid == null) {
            return Option.none();
        }
        return this.hiveMembershipCache.get(uuid);
    }

    public Map<class_1299<?>, List<Map.Entry<UUID, HiveMemberData>>> getMembersByEntityType() {
        return this.hiveMembershipCache.getMembersByEntityTypeMap();
    }

    public Collection<Map.Entry<UUID, HiveMemberData>> getMembersMatching(Predicate<class_1299<?>> predicate) {
        return this.hiveMembershipCache.getMembersByEntityTypeMap().keySet().stream().filter(predicate).map(this.hiveMembershipCache::getMembersByEntityType).flatMap(Collection::stream).toList();
    }

    @Override
    public void load(class_2487 compoundTag) {
        class_2487 hiveMemberDataMapTag = compoundTag.method_10562(HIVE_MEMBER_DATA_KEY);
        for (String key : hiveMemberDataMapTag.method_10541()) {
            UUID entityUUID = UUID.fromString(key);
            class_2487 hiveMemberDataTag = hiveMemberDataMapTag.method_10562(key);
            HiveMemberData.CODEC.parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)hiveMemberDataTag)).resultOrPartial(arg_0 -> ((Logger)AVP.LOGGER).error(arg_0)).ifPresent(hiveMemberData -> this.hiveMembershipCache.add(entityUUID, hiveMemberData));
        }
    }

    @Override
    public void save(class_2487 compoundTag) {
        class_2487 hiveMemberDataTag = new class_2487();
        this.hiveMembershipCache.streamEntries().forEach(entry -> HiveMemberData.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)((HiveMemberData)entry.getValue())).resultOrPartial(arg_0 -> ((Logger)AVP.LOGGER).error(arg_0)).ifPresent(tag -> hiveMemberDataTag.method_10566(((UUID)entry.getKey()).toString(), tag)));
        compoundTag.method_10566(HIVE_MEMBER_DATA_KEY, (class_2520)hiveMemberDataTag);
    }
}

