/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.level.saveddata;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.hive.Hive;
import com.avp.AVP;
import com.avp.common.util.AVPPredicates;
import com.just.core.functional.option.Option;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

public class HiveLevelData
extends class_18 {
    private static final String DATA_NAME = "hive_data";
    private static final String HIVES_KEY = "hives";
    private final class_1937 level;
    private final Map<UUID, Hive> hiveByIdMap;

    private HiveLevelData(class_1937 level) {
        this(level, new HashMap<UUID, Hive>());
    }

    private HiveLevelData(class_1937 level, Map<UUID, Hive> hiveByIdMap) {
        this.hiveByIdMap = hiveByIdMap;
        this.level = level;
    }

    public void tick() {
        this.hiveByIdMap.values().removeIf(hive -> {
            hive.tick();
            boolean shouldRemove = hive.isRemoved();
            if (shouldRemove) {
                hive.onRemove();
            }
            return shouldRemove;
        });
        this.method_80();
    }

    public Option<Hive> findNearestHive(class_2338 blockPos) {
        return this.findNearestHive(blockPos, AVPPredicates.alwaysTrue());
    }

    public Option<Hive> findNearestHive(class_2338 blockPos, Predicate<Hive> hivePredicate) {
        double distanceSquared = Double.MAX_VALUE;
        Hive closestHive = null;
        for (Hive hive : this.hiveByIdMap.values()) {
            class_2338 centerPos = hive.centerPosition();
            double relativeDistanceSquared = blockPos.method_10268((double)centerPos.method_10263(), (double)centerPos.method_10264(), (double)centerPos.method_10260());
            if (!(relativeDistanceSquared < distanceSquared) || !hivePredicate.test(hive)) continue;
            distanceSquared = relativeDistanceSquared;
            closestHive = hive;
        }
        return Option.ofNullable(closestHive);
    }

    public Hive createHive(Alien alien) {
        Hive hive = this.createHive(alien.method_24515());
        hive.setVariant(alien.getVariant());
        hive.getMembershipManager().addMember((class_1297)alien);
        hive.getLeadershipManager().setLeaderId(alien.method_5667());
        hive.ping((class_1297)alien);
        return hive;
    }

    public Hive createHive(class_2338 blockPos) {
        UUID id = UUID.randomUUID();
        Hive hive = new Hive(this.level, id);
        hive.moveCenter(blockPos);
        this.hiveByIdMap.put(id, hive);
        AVP.LOGGER.debug("Created hive: {}", (Object)id);
        return hive;
    }

    public void removeHive(Hive hive) {
        this.hiveByIdMap.remove(hive.id());
    }

    public Collection<Hive> allHives() {
        return this.hiveByIdMap.values();
    }

    public Option<Hive> hive(@NotNull UUID id) {
        return Option.ofNullable((Object)this.hiveByIdMap.get(id));
    }

    public boolean hasHive(Hive hive) {
        return this.hive(hive.id()).isSome();
    }

    public static HiveLevelData load(class_1937 level, class_2487 compoundTag, class_7225.class_7874 provider) {
        HashMap<UUID, Hive> map = new HashMap<UUID, Hive>();
        class_2487 hivesTag = compoundTag.method_10562(HIVES_KEY);
        for (String key : hivesTag.method_10541()) {
            UUID id = UUID.fromString(key);
            class_2487 hiveTag = hivesTag.method_10562(key);
            Hive hive = new Hive(level, id);
            hive.load(hiveTag);
            map.put(hive.id(), hive);
        }
        return new HiveLevelData(level, map);
    }

    @NotNull
    public class_2487 method_75(class_2487 compoundTag, @NotNull class_7225.class_7874 provider) {
        class_2487 hivesTag = new class_2487();
        this.hiveByIdMap.forEach((hiveId, hive) -> {
            class_2487 hiveTag = new class_2487();
            hive.save(hiveTag);
            hivesTag.method_10566(hiveId.toString(), (class_2520)hiveTag);
        });
        compoundTag.method_10566(HIVES_KEY, (class_2520)hivesTag);
        return compoundTag;
    }

    public static Option<HiveLevelData> getOrCreate(class_1937 level) {
        return level.field_9236 ? Option.none() : Option.some((Object)((Object)((HiveLevelData)((class_3218)level).method_17983().method_17924(HiveLevelData.factory(level), DATA_NAME))));
    }

    public static class_18.class_8645<HiveLevelData> factory(class_1937 level) {
        return new class_18.class_8645(() -> new HiveLevelData(level), (compoundTag, provider) -> HiveLevelData.load(level, compoundTag, provider), null);
    }
}

