/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.level.saveddata;

import com.alien.common.model.alien.variant.AlienVariant;
import com.just.core.functional.option.Option;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

public class StrainLeakData
extends class_18 {
    private static final String DATA_NAME = "strain_leak_data";
    private static final String NBT_ALIEN_VARIANTS = "alienVariants";
    private final Map<AlienVariant, Integer> variantCounts = new HashMap<AlienVariant, Integer>();

    private StrainLeakData(class_1937 level) {
        if (level.method_27983() == class_1937.field_25179) {
            this.variantCounts.put(AlienVariant.NORMAL, 1000000);
        } else if (level.method_27983() == class_1937.field_25180) {
            this.variantCounts.put(AlienVariant.NETHER, 1000000);
        }
    }

    public boolean hasVariant(AlienVariant variant) {
        return this.variantCounts.getOrDefault((Object)variant, 0) > 0;
    }

    public int getCount(AlienVariant variant) {
        return this.variantCounts.getOrDefault((Object)variant, 0);
    }

    public Set<AlienVariant> getVariants() {
        return this.variantCounts.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).map(Map.Entry::getKey).collect(Collectors.toUnmodifiableSet());
    }

    public void add(AlienVariant variant, int amount) {
        if (amount == 0) {
            return;
        }
        this.variantCounts.compute(variant, (key, oldValue) -> {
            int current = oldValue == null ? 0 : oldValue;
            int newCount = current + amount;
            if (newCount <= 0) {
                return null;
            }
            return newCount;
        });
        this.method_80();
    }

    @NotNull
    public class_2487 method_75(@NotNull class_2487 compoundTag, @NotNull class_7225.class_7874 provider) {
        class_2487 variantTag = new class_2487();
        for (Map.Entry<AlienVariant, Integer> entry : this.variantCounts.entrySet()) {
            int id = entry.getKey().getId();
            Integer count = entry.getValue();
            if (count <= 0) continue;
            variantTag.method_10569(Integer.toString(id), count.intValue());
        }
        compoundTag.method_10566(NBT_ALIEN_VARIANTS, (class_2520)variantTag);
        return compoundTag;
    }

    public static StrainLeakData load(class_1937 level, class_2487 compoundTag, class_7225.class_7874 provider) {
        StrainLeakData data = new StrainLeakData(level);
        if (compoundTag.method_10573(NBT_ALIEN_VARIANTS, 10)) {
            class_2487 variantTag = compoundTag.method_10562(NBT_ALIEN_VARIANTS);
            for (String key : variantTag.method_10541()) {
                try {
                    int id = Integer.parseInt(key);
                    int count = variantTag.method_10550(key);
                    AlienVariant.getById(id).ifSome(variant -> {
                        if (count > 0) {
                            data.variantCounts.put((AlienVariant)((Object)variant), count);
                        }
                    });
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return data;
    }

    public static Option<StrainLeakData> getOrCreate(class_1937 level) {
        return level.field_9236 ? Option.none() : Option.some((Object)((Object)((StrainLeakData)((class_3218)level).method_17983().method_17924(StrainLeakData.factory(level), DATA_NAME))));
    }

    public static class_18.class_8645<StrainLeakData> factory(class_1937 level) {
        return new class_18.class_8645(() -> new StrainLeakData(level), (compoundTag, provider) -> StrainLeakData.load(level, compoundTag, provider), null);
    }
}

