/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.gameplay.ai.goal.combat;

import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_2183;
import net.minecraft.class_243;
import org.jetbrains.annotations.Nullable;

public class LungeAtTargetGoal
extends class_1352 {
    private static final int DEFAULT_WIND_UP_TIME_IN_TICKS = 10;
    private static final float DEFAULT_DISTANCE_TARGET = -1.0f;
    private final class_1308 mob;
    private final int maxCooldown;
    private final float normalizedChance;
    private final double minLungeRange;
    private final double maxLungeRange;
    private float distanceToTarget;
    private int windUpTimeInTicks;
    private int cooldown;
    @Nullable
    Runnable onLungeCallback;

    public LungeAtTargetGoal(class_1308 mob, float normalizedChance, int cooldown, double minLungeRange, double maxLungeRange) {
        this.mob = mob;
        this.maxCooldown = cooldown;
        this.normalizedChance = normalizedChance;
        this.minLungeRange = minLungeRange;
        this.maxLungeRange = maxLungeRange;
        this.cooldown = 0;
        this.resetWindUpTimeInTicks();
        this.distanceToTarget = -1.0f;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18407, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        this.cooldown = Math.max(this.cooldown - 1, 0);
        boolean canUse = !this.isOnCooldown() && this.mob.method_59922().method_43057() < this.normalizedChance;
        return this.mob.method_5968() != null && this.mob.method_24828() && this.isInRange() && canUse && this.mob.method_5985().method_6369((class_1297)this.mob.method_5968());
    }

    public boolean method_6266() {
        return this.mob.method_5968() != null && this.mob.method_24828() && this.mob.method_5985().method_6369((class_1297)this.mob.method_5968());
    }

    public void method_6269() {
        super.method_6269();
        class_1309 target = this.mob.method_5968();
        if (target != null) {
            this.mob.method_5702(class_2183.class_2184.field_9851, target.method_33571());
            this.mob.method_5988().method_35111((class_1297)target);
        }
    }

    public void method_6268() {
        class_1309 target = this.mob.method_5968();
        if (target == null) {
            return;
        }
        this.mob.method_5702(class_2183.class_2184.field_9851, target.method_33571());
        this.mob.method_5988().method_35111((class_1297)target);
        float currentDistanceToTarget = this.mob.method_5739((class_1297)target);
        if (this.distanceToTarget == -1.0f) {
            this.distanceToTarget = currentDistanceToTarget;
        }
        if (this.mob.method_6117() > 0 && this.mob.field_6012 - this.mob.method_6117() < 20 || currentDistanceToTarget > this.distanceToTarget) {
            this.windUpTimeInTicks = 0;
        }
        if (this.windUpTimeInTicks > 0) {
            --this.windUpTimeInTicks;
            this.mob.method_5942().method_6340();
            return;
        }
        this.distanceToTarget = currentDistanceToTarget;
        class_243 deltaMovement = this.mob.method_18798().method_1021(0.2);
        class_243 vectorDifference = target.method_33571().method_1020(this.mob.method_33571());
        vectorDifference = vectorDifference.method_1029().method_1021(0.2 * (double)this.distanceToTarget).method_1031(deltaMovement.field_1352, 0.0, deltaMovement.field_1350);
        this.mob.method_18800(vectorDifference.field_1352, Math.max(0.6, vectorDifference.field_1351), vectorDifference.field_1350);
        if (this.onLungeCallback != null) {
            this.onLungeCallback.run();
        }
        this.resetWindUpTimeInTicks();
        this.resetCooldown();
    }

    public void method_6270() {
        super.method_6270();
        this.resetCooldown();
        this.resetWindUpTimeInTicks();
        this.distanceToTarget = -1.0f;
    }

    public boolean method_38846() {
        return true;
    }

    public LungeAtTargetGoal setOnLungeCallback(@Nullable Runnable onLungeCallback) {
        this.onLungeCallback = onLungeCallback;
        return this;
    }

    private boolean isOnCooldown() {
        return this.cooldown > 0;
    }

    private void resetCooldown() {
        this.cooldown = this.maxCooldown;
    }

    private void resetWindUpTimeInTicks() {
        this.windUpTimeInTicks = 10;
    }

    private boolean isInRange() {
        boolean isTargetTooFarAwayVertically;
        boolean isTargetTooFarAwayHorizontally;
        class_1309 target = this.mob.method_5968();
        if (target == null) {
            return false;
        }
        double dx = this.mob.method_23317() - target.method_23317();
        double dz = this.mob.method_23321() - target.method_23321();
        double horizontalDistanceSqr = dx * dx + dz * dz;
        double minimumRangeSquared = this.minLungeRange * this.minLungeRange;
        double maximumRangeSquared = this.maxLungeRange * this.maxLungeRange;
        boolean bl = isTargetTooFarAwayHorizontally = horizontalDistanceSqr > maximumRangeSquared;
        if (isTargetTooFarAwayHorizontally) {
            return false;
        }
        double dy = Math.abs(this.mob.method_23318() - target.method_23318());
        double verticalDistanceSqr = dy * dy;
        boolean bl2 = isTargetTooFarAwayVertically = verticalDistanceSqr > maximumRangeSquared;
        if (isTargetTooFarAwayVertically) {
            return false;
        }
        float minVerticalLungeRange = this.mob.method_17682() * this.mob.method_17682();
        boolean isTargetTooCloseHorizontally = horizontalDistanceSqr < minimumRangeSquared;
        boolean isTargetTooCloseVertically = dy <= (double)minVerticalLungeRange;
        return !isTargetTooCloseHorizontally || !isTargetTooCloseVertically;
    }
}

