/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.gameplay.effect;

import com.avp.common.registry.init.AVPMobEffects;
import com.avp.common.registry.key.AVPDamageTypeKeys;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.avp.common.util.AVPPredicates;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import mod.azure.azurelib.core.object.Color;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_4081;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class RadiationStatusEffect
extends class_1291 {
    public static final int EFFECT_DURATION_IN_TICKS = (int)TimeUnit.MINUTES.toSeconds(4L) * 20;
    private static final Map<class_1309, Integer> EFFECT_TRACKER = new WeakHashMap<class_1309, Integer>();

    public RadiationStatusEffect() {
        super(class_4081.field_18272, Color.GREEN.getColor());
    }

    public boolean method_5552(int i, int amplifier) {
        return true;
    }

    public boolean method_5572(@NotNull class_1309 livingEntity, int amplifier) {
        int threshold;
        if (AVPPredicates.IS_IMMORTAL.test(livingEntity) || livingEntity.method_5864().method_20210(AVPEntityTypeTags.RADIATION_RESISTANT)) {
            livingEntity.method_6016(AVPMobEffects.RADIATION.getHolder());
            return false;
        }
        Integer currentDuration = EFFECT_TRACKER.getOrDefault(livingEntity, 0);
        switch (amplifier) {
            case 0: {
                this.applyLevel1RadiationSideEffects(livingEntity, amplifier);
                break;
            }
            case 1: {
                this.applyLevel2RadiationSideEffects(livingEntity, amplifier);
                break;
            }
            default: {
                this.applyDefaultRadiationSideEffects(livingEntity, amplifier);
            }
        }
        switch (amplifier) {
            case 0: {
                int n = EFFECT_DURATION_IN_TICKS / 4;
                break;
            }
            case 1: {
                int n = EFFECT_DURATION_IN_TICKS / 2;
                break;
            }
            default: {
                int n = threshold = EFFECT_DURATION_IN_TICKS;
            }
        }
        if (currentDuration >= threshold && amplifier < 2) {
            EFFECT_TRACKER.put(livingEntity, 0);
            livingEntity.method_6092(new class_1293(AVPMobEffects.RADIATION.getHolder(), EFFECT_DURATION_IN_TICKS, amplifier + 1));
        } else {
            EFFECT_TRACKER.put(livingEntity, currentDuration + 1);
        }
        return livingEntity.method_5805();
    }

    private void applyLevel1RadiationSideEffects(class_1309 livingEntity, int amplifier) {
        this.handleStatusEffects(livingEntity, amplifier, class_1294.field_5911, class_1294.field_5903);
        if (livingEntity.field_6012 % 80 == 0) {
            livingEntity.method_5643(RadiationStatusEffect.createRadiationDamageSource(livingEntity), 0.5f);
        }
    }

    private void applyLevel2RadiationSideEffects(class_1309 livingEntity, int amplifier) {
        this.handleStatusEffects(livingEntity, amplifier, class_1294.field_5911, class_1294.field_5903, class_1294.field_5909);
        if (livingEntity.field_6012 % 40 == 0) {
            livingEntity.method_5643(RadiationStatusEffect.createRadiationDamageSource(livingEntity), 1.0f);
        }
    }

    private void applyDefaultRadiationSideEffects(class_1309 livingEntity, int amplifier) {
        this.handleStatusEffects(livingEntity, amplifier, class_1294.field_5911, class_1294.field_5903, class_1294.field_5909, class_1294.field_5919);
        if (livingEntity.field_6012 % 20 == 0) {
            livingEntity.method_5643(RadiationStatusEffect.createRadiationDamageSource(livingEntity), 2.0f);
        }
    }

    @SafeVarargs
    private void handleStatusEffects(@NotNull class_1309 livingEntity, int amplifier, class_6880<class_1291> ... statusEffects) {
        for (class_6880<class_1291> effect : statusEffects) {
            if (livingEntity.method_6059(effect)) continue;
            livingEntity.method_6092(new class_1293(effect, 100, amplifier, true, true));
        }
    }

    private static class_1282 createRadiationDamageSource(class_1309 livingEntity) {
        return new class_1282((class_6880)livingEntity.method_56673().method_30530(class_7924.field_42534).method_40290(AVPDamageTypeKeys.RADIATION));
    }
}

