/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.gameplay.explosion;

import com.avp.common.gameplay.explosion.Explosion;
import com.avp.common.gameplay.explosion.ExplosionBlockSampler;
import com.avp.common.gameplay.explosion.ExplosionBlockSamplerPredicate;
import com.avp.common.gameplay.explosion.ExplosionCallbacks;
import com.avp.common.gameplay.explosion.ExplosionConfig;
import com.lib.common.util.DirectionUtil;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3218;

public class ExplosionBuilder {
    private final ExplosionCallbacks.Builder callbacksBuilder;
    private final class_243 center;
    private final class_3218 level;
    private final Map<class_2350, Integer> directionToRadiusMap;
    int blockSampleCountPerCycle;
    int cycleDelayInTicks;
    private ExplosionBlockSamplerPredicate samplerPredicate;

    ExplosionBuilder(class_3218 level, class_243 center) {
        this.level = level;
        this.callbacksBuilder = ExplosionCallbacks.builder();
        this.center = center;
        this.directionToRadiusMap = new EnumMap<class_2350, Integer>(class_2350.class);
        this.blockSampleCountPerCycle = Short.MAX_VALUE;
        this.cycleDelayInTicks = 1;
        this.samplerPredicate = ExplosionBlockSamplerPredicate.DEFAULT;
    }

    public ExplosionBuilder onBlockSample(ExplosionBlockSampler sampler) {
        this.callbacksBuilder.withOnBlockSampleCallback(sampler);
        return this;
    }

    public ExplosionBuilder onCycleFinish(Consumer<List<class_2338>> callback) {
        this.callbacksBuilder.withOnCycleFinishCallback(callback);
        return this;
    }

    public ExplosionBuilder onCycleStart(Runnable callback) {
        this.callbacksBuilder.withOnCycleStartCallback(callback);
        return this;
    }

    public ExplosionBuilder onExplosionFinish(Runnable callback) {
        this.callbacksBuilder.withOnExplosionFinishCallback(callback);
        return this;
    }

    public ExplosionBuilder onExplosionStart(Runnable callback) {
        this.callbacksBuilder.withOnExplosionStartCallback(callback);
        return this;
    }

    public ExplosionBuilder withBlockSampleCountPerCycle(int blockSampleCountPerCycle) {
        this.blockSampleCountPerCycle = blockSampleCountPerCycle;
        return this;
    }

    public ExplosionBuilder withCycleDelayInTicks(int cycleDelayInTicks) {
        this.cycleDelayInTicks = cycleDelayInTicks;
        return this;
    }

    public ExplosionBuilder withRadius(int radius) {
        for (class_2350 direction : DirectionUtil.VALUES) {
            this.withRadius(direction, radius);
        }
        return this;
    }

    public ExplosionBuilder withRadius(class_2350.class_2353 plane, int radius) {
        plane.method_29716().forEach(direction -> this.withRadius((class_2350)direction, radius));
        return this;
    }

    public ExplosionBuilder withRadius(class_2350.class_2351 axis, int radius) {
        class_2350 direction = class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)class_2350.class_2352.field_11056);
        this.withRadius(direction, radius);
        this.withRadius(direction.method_10153(), radius);
        return this;
    }

    public ExplosionBuilder withRadius(class_2350 direction, int radius) {
        this.directionToRadiusMap.put(direction, radius);
        return this;
    }

    public ExplosionBuilder withSamplerPredicate(ExplosionBlockSamplerPredicate samplerPredicate) {
        this.samplerPredicate = samplerPredicate;
        return this;
    }

    public Explosion build() {
        ExplosionCallbacks callbacks = this.callbacksBuilder.build();
        class_2338 centerBlockPosition = new class_2338((int)this.center.field_1352, (int)this.center.field_1351, (int)this.center.field_1350);
        ExplosionConfig config = new ExplosionConfig(this.blockSampleCountPerCycle, this.center, centerBlockPosition, this.cycleDelayInTicks, this.directionToRadiusMap);
        return new Explosion(this.level, callbacks, config, this.samplerPredicate);
    }
}

