/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.model.spawning;

import com.avp.common.config.AVPConfig;
import com.avp.common.model.spawning.AVPEntitySpawnConfigData;
import com.avp.common.model.spawning.AVPEntitySpawnPlacementData;
import com.avp.common.registry.AVPDeferredHolder;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1317;
import net.minecraft.class_1959;
import net.minecraft.class_2902;
import net.minecraft.class_6862;
import net.minecraft.class_6908;
import net.minecraft.class_9168;
import net.minecraft.class_9169;

public final class AVPEntitySpawnData<T extends class_1308> {
    private final AVPDeferredHolder<class_1299<T>> entityTypeDeferredHolder;
    private final AVPEntitySpawnConfigData configData;
    private final AVPEntitySpawnPlacementData<T> placementData;
    private final boolean configDisabled;
    private final boolean placementDisabled;

    public static <T extends class_1308> Builder<T> builder(AVPDeferredHolder<class_1299<T>> entityTypeDeferredHolder) {
        return new Builder<T>(entityTypeDeferredHolder);
    }

    private AVPEntitySpawnData(AVPDeferredHolder<class_1299<T>> entityTypeDeferredHolder, AVPEntitySpawnConfigData configData, AVPEntitySpawnPlacementData<T> placementData, boolean configDisabled, boolean placementDisabled) {
        this.entityTypeDeferredHolder = entityTypeDeferredHolder;
        this.configData = configData;
        this.placementData = placementData;
        this.configDisabled = configDisabled;
        this.placementDisabled = placementDisabled;
    }

    public class_1299<T> getEntityType() {
        return this.entityTypeDeferredHolder.get();
    }

    public AVPEntitySpawnConfigData getConfigData() {
        return this.configData;
    }

    public AVPEntitySpawnPlacementData<T> getPlacementData() {
        return this.placementData;
    }

    public boolean isConfigDisabled() {
        return this.configDisabled;
    }

    public boolean isPlacementDisabled() {
        return this.placementDisabled;
    }

    public static class Builder<T extends class_1308> {
        private final AVPDeferredHolder<class_1299<T>> entityTypeDeferredHolder;
        private class_6862<class_1959> biomeTagKey;
        private AVPConfig.SpawnConfigs.SpawnSettings spawnSettings;
        private class_2902.class_2903 heightmapType;
        private class_9168 spawnPlacementType;
        private class_1317.class_4306<T> spawnPredicate;
        private boolean configDisabled;
        private boolean placementDisabled;

        public Builder(AVPDeferredHolder<class_1299<T>> entityTypeDeferredHolder) {
            this.entityTypeDeferredHolder = entityTypeDeferredHolder;
            this.biomeTagKey = class_6908.field_37393;
            this.heightmapType = class_2902.class_2903.field_13203;
            this.spawnPlacementType = class_9169.field_48745;
            this.spawnSettings = new AVPConfig.SpawnConfigs.SpawnSettings(true, 1, 3, 10);
            this.spawnPredicate = class_1308::method_20636;
            this.configDisabled = false;
            this.placementDisabled = false;
        }

        public Builder<T> withBiomeTagKey(class_6862<class_1959> biomeTagKey) {
            this.biomeTagKey = biomeTagKey;
            return this;
        }

        public Builder<T> withHeightmapType(class_2902.class_2903 heightmapType) {
            this.heightmapType = heightmapType;
            return this;
        }

        public Builder<T> withSpawnPlacement(class_9168 spawnPlacementType) {
            this.spawnPlacementType = spawnPlacementType;
            return this;
        }

        public Builder<T> withSpawnSettings(AVPConfig.SpawnConfigs.SpawnSettings spawnSettings) {
            this.spawnSettings = spawnSettings;
            return this;
        }

        public Builder<T> withSpawnPredicate(class_1317.class_4306<T> spawnPredicate) {
            this.spawnPredicate = spawnPredicate;
            return this;
        }

        public Builder<T> disableConfig() {
            this.configDisabled = true;
            return this;
        }

        public Builder<T> disablePlacement() {
            this.placementDisabled = true;
            return this;
        }

        public AVPEntitySpawnData<T> build() {
            class_1317.class_4306 proxySpawnPredicate = (entityType, serverLevelAccessor, mobSpawnType, blockPos, randomSource) -> this.spawnSettings.enabled && this.spawnPredicate.test(entityType, serverLevelAccessor, mobSpawnType, blockPos, randomSource);
            return new AVPEntitySpawnData<T>(this.entityTypeDeferredHolder, new AVPEntitySpawnConfigData(this.biomeTagKey, this.spawnSettings), new AVPEntitySpawnPlacementData(this.spawnPlacementType, this.heightmapType, proxySpawnPredicate), this.configDisabled, this.placementDisabled);
        }
    }
}

