/*
 * Decompiled with CFR 0.152.
 */
package com.avp.fabric;

import com.avp.AVP;
import com.avp.common.AVPEvents;
import com.avp.common.data.worldgen.AVPVillageInjection;
import com.avp.common.registry.init.AVPVillagerProfessions;
import com.avp.common.registry.key.AVPVillagerGiftKeys;
import com.avp.fabric.common.DispenserBlockBehaviors;
import com.avp.fabric.common.FlammableBlockRegistry;
import com.avp.fabric.common.worldgen.WorldGen;
import com.avp.fabric.data.loot.LootTableModifier;
import com.avp.fabric.service.FabricRegistryService;
import com.avp.mixin.GiveGiftToHeroAccessor;
import com.avp.mixin.ParrotSoundMapAccessor;
import com.avp.service.Services;
import com.lib.common.network.DataContainer;
import com.lib.common.network.DataUser;
import com.mojang.brigadier.CommandDispatcher;
import com.predator.common.registry.init.PredatorEntityTypes;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.EntityTrackingEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1928;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3785;
import net.minecraft.class_3852;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5497;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class AVPFabric
implements ModInitializer {
    private static final FabricRegistryService REGISTRY = (FabricRegistryService)Services.REGISTRY;

    public void onInitialize() {
        AVP.initialize();
        WorldGen.initialize();
        DispenserBlockBehaviors.initialize();
        LootTableModifier.initialize();
        FlammableBlockRegistry.initialize();
        ServerTickEvents.START_WORLD_TICK.register(this::onWorldTick);
        ServerLifecycleEvents.SERVER_STARTING.register(this::addNewVillageBuilding);
        EntityTrackingEvents.START_TRACKING.register((trackedEntity, player) -> {
            if (trackedEntity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)trackedEntity;
                ((DataUser)livingEntity).getDataContainer().syncToClient((class_1297)livingEntity, DataContainer.SyncType.ALL);
            }
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> REGISTRY.getLiteralArgumentBuilders().forEach(arg_0 -> ((CommandDispatcher)dispatcher).register(arg_0)));
        CommonLifecycleEvents.TAGS_LOADED.register((registries, client) -> AVPEvents.onTagsUpdated());
    }

    private void onWorldTick(class_3218 serverLevel) {
        AVP.CUSTOM_SPAWNER.method_6445(serverLevel, serverLevel.method_8450().method_8355(class_1928.field_19390), true);
        AVP.NUKED_ASH_PLACEMENT.tick(serverLevel);
        AVPFabric.modifyGifts();
        AVPFabric.modifyParrotSounds();
    }

    public static void modifyParrotSounds() {
        Map<class_1299<?>, class_3414> sounds = ParrotSoundMapAccessor.getSoundMap();
        sounds.put(PredatorEntityTypes.YAUTJA.get(), class_3417.field_38365);
    }

    public static void modifyGifts() {
        Map<class_3852, class_5321<class_52>> gifts = GiveGiftToHeroAccessor.getGifts();
        gifts.put(AVPVillagerProfessions.COMMISSARY.get(), AVPVillagerGiftKeys.COMMISSARY_GIFT_LOOT_TABLE);
    }

    public void addNewVillageBuilding(MinecraftServer event) {
        class_2378 templatePoolRegistry = event.method_30611().method_30530(class_7924.field_41249);
        class_2378 processorListRegistry = event.method_30611().method_30530(class_7924.field_41247);
        AVPVillageInjection.addBuildingToPool((class_2378<class_3785>)templatePoolRegistry, (class_2378<class_5497>)processorListRegistry, class_2960.method_60656((String)"village/plains/houses"), "avp:village/plains/houses/plains_commissary", 5);
        AVPVillageInjection.addBuildingToPool((class_2378<class_3785>)templatePoolRegistry, (class_2378<class_5497>)processorListRegistry, class_2960.method_60656((String)"village/snowy/houses"), "avp:village/snowy/houses/snowy_commissary", 5);
        AVPVillageInjection.addBuildingToPool((class_2378<class_3785>)templatePoolRegistry, (class_2378<class_5497>)processorListRegistry, class_2960.method_60656((String)"village/savanna/houses"), "avp:village/savanna/houses/savanna_commissary", 5);
        AVPVillageInjection.addBuildingToPool((class_2378<class_3785>)templatePoolRegistry, (class_2378<class_5497>)processorListRegistry, class_2960.method_60656((String)"village/taiga/houses"), "avp:village/taiga/houses/taiga_commissary", 5);
        AVPVillageInjection.addBuildingToPool((class_2378<class_3785>)templatePoolRegistry, (class_2378<class_5497>)processorListRegistry, class_2960.method_60656((String)"village/desert/houses"), "avp:village/desert/houses/desert_commissary", 5);
    }
}

