/*
 * Decompiled with CFR 0.152.
 */
package com.avp.fabric.data.recipe.builder;

import com.human.common.gameplay.recipe.IndustrialFurnaceRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1747;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2446;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_7709;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import net.minecraft.class_8782;
import net.minecraft.class_8790;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class IndustrialFurnaceRecipeBuilder
implements class_5797 {
    private class_7800 category;
    private class_7709 bookCategory;
    private class_1792 result;
    private class_1856 ingredient;
    private float experience;
    private int cookingTime;
    private Map<String, class_175<?>> criteria = new LinkedHashMap();
    @Nullable
    private String group;

    private IndustrialFurnaceRecipeBuilder(class_7800 recipeCategory, class_7709 cookingBookCategory, class_1935 itemLike, class_1856 ingredient, float experience, int cookingTime) {
        this.category = recipeCategory;
        this.bookCategory = cookingBookCategory;
        this.result = itemLike.method_8389();
        this.ingredient = ingredient;
        this.experience = experience;
        this.cookingTime = cookingTime;
    }

    public static IndustrialFurnaceRecipeBuilder smelting(class_1856 ingredient, class_7800 recipeCategory, class_1935 itemLike, float experience, int cookingTime) {
        return new IndustrialFurnaceRecipeBuilder(recipeCategory, IndustrialFurnaceRecipeBuilder.determineSmeltingRecipeCategory(itemLike), itemLike, ingredient, experience, cookingTime);
    }

    public IndustrialFurnaceRecipeBuilder withCategory(class_7800 category) {
        this.category = category;
        return this;
    }

    public IndustrialFurnaceRecipeBuilder into(class_1935 itemLike) {
        this.result = itemLike.method_8389();
        return this;
    }

    public IndustrialFurnaceRecipeBuilder withExperience(float experience) {
        this.experience = experience;
        return this;
    }

    public IndustrialFurnaceRecipeBuilder withCookingTime(int cookingTime) {
        this.cookingTime = cookingTime;
        return this;
    }

    public IndustrialFurnaceRecipeBuilder unlockedBy(String string, class_175<?> criterion) {
        this.criteria.put(string, criterion);
        return this;
    }

    public IndustrialFurnaceRecipeBuilder group(@Nullable String string) {
        this.group = string;
        return this;
    }

    public class_1792 method_36441() {
        return this.result;
    }

    public void method_17972(class_8790 recipeOutput, class_2960 resourceLocation) {
        this.ensureValid(resourceLocation);
        class_161.class_162 builder = recipeOutput.method_53818().method_705("has_the_recipe", class_2119.method_27847((class_2960)resourceLocation)).method_703(class_170.class_171.method_753((class_2960)resourceLocation)).method_704(class_8782.class_8797.field_1257);
        this.criteria.forEach((arg_0, arg_1) -> ((class_161.class_162)builder).method_705(arg_0, arg_1));
        IndustrialFurnaceRecipe recipe = new IndustrialFurnaceRecipe(Objects.requireNonNullElse(this.group, ""), this.bookCategory, this.ingredient, new class_1799((class_1935)this.result), this.experience, this.cookingTime);
        recipeOutput.method_53819(resourceLocation, (class_1860)recipe, builder.method_695(resourceLocation.method_45138("recipes/" + this.category.method_46203() + "/")));
    }

    public void saveWithSuffix(class_8790 recipeOutput, String suffix) {
        class_2960 resourceLocation = class_2960.method_60655((String)"avp", (String)(class_7923.field_41178.method_10221((Object)this.result).method_12832() + "_from_" + this.ingredient.method_8105()[0].method_7922() + suffix));
        this.method_17972(recipeOutput, resourceLocation);
    }

    private static class_7709 determineSmeltingRecipeCategory(class_1935 itemLike) {
        if (itemLike.method_8389().method_57347().method_57832(class_9334.field_50075)) {
            return class_7709.field_40242;
        }
        return itemLike.method_8389() instanceof class_1747 ? class_7709.field_40243 : class_7709.field_40244;
    }

    private void ensureValid(class_2960 resourceLocation) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(resourceLocation));
        }
    }

    public static void ensureRegistration(class_8790 recipeOutput) {
        for (Map.Entry<class_1792, class_1792> entry : IndustrialFurnaceRecipe.MELTING_RECIPES.entrySet()) {
            class_1792 input = entry.getKey();
            class_1792 output = entry.getValue();
            class_2960 recipeId = class_2960.method_60655((String)"avp", (String)(class_7923.field_41178.method_10221((Object)output).method_12832() + "_from_" + class_7923.field_41178.method_10221((Object)input).method_12832() + "_industrial_furnace"));
            IndustrialFurnaceRecipe recipe = new IndustrialFurnaceRecipe("", class_7709.field_40243, class_1856.method_8091((class_1935[])new class_1935[]{input}), new class_1799((class_1935)output), 0.1f, 100);
            class_161.class_162 advancementBuilder = recipeOutput.method_53818().method_705("has_the_recipe", class_2119.method_27847((class_2960)recipeId)).method_703(class_170.class_171.method_753((class_2960)recipeId)).method_704(class_8782.class_8797.field_1257);
            advancementBuilder.method_705("has_item", class_2446.method_10426((class_1935)input));
            recipeOutput.method_53819(recipeId, (class_1860)recipe, advancementBuilder.method_695(recipeId.method_45138("recipes/building_blocks/")));
        }
    }
}

