/*
 * Decompiled with CFR 0.152.
 */
package com.avp.fabric.service;

import com.avp.AVPResources;
import com.avp.common.config.AVPConfig;
import com.avp.common.model.spawning.AVPEntitySpawnData;
import com.avp.common.network.NetworkHandler;
import com.avp.common.network.PacketDirection;
import com.avp.common.registry.AVPDeferredHolder;
import com.avp.service.RegistryService;
import com.lib.common.util.codec.stream.adapter.JustStreamCodecToMojangStreamCodecAdapter;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mod.azure.azurelib.common.animation.cache.AzIdentityRegistry;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.fabricmc.fabric.api.object.builder.v1.world.poi.PointOfInterestHelper;
import net.fabricmc.fabric.api.registry.CompostingChanceRegistry;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_4158;
import net.minecraft.class_5132;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_9168;
import org.jetbrains.annotations.NotNull;

public class FabricRegistryService
implements RegistryService {
    private final List<NetworkHandler<?>> clientBoundPacketHandlers = new ArrayList();
    private final List<LiteralArgumentBuilder<class_2168>> literalArgumentBuilders = new ArrayList<LiteralArgumentBuilder<class_2168>>();

    @Override
    public <T> AVPDeferredHolder<T> register(class_2378<? super T> registry, String id, Supplier<? extends T> supplier) {
        class_6880.class_6883 reference;
        T object = supplier.get();
        if (object instanceof class_4158) {
            class_4158 poiType = (class_4158)object;
            return this.registerPoiType(id, poiType);
        }
        class_6880.class_6883 holder = reference = class_2378.method_47985(registry, (class_2960)AVPResources.location(id), object);
        return new AVPDeferredHolder<Object>(() -> ((class_6880)holder).comp_349(), () -> FabricRegistryService.lambda$register$0((class_6880)holder));
    }

    @NotNull
    private <T> AVPDeferredHolder<T> registerPoiType(String id, class_4158 poiType) {
        class_2960 location = AVPResources.location(id);
        PointOfInterestHelper.register((class_2960)location, (int)poiType.comp_816(), (int)poiType.comp_817(), (Iterable)poiType.comp_815());
        class_6880 holder = (class_6880)class_7923.field_41128.method_55841(location).orElseThrow();
        return new AVPDeferredHolder<Object>(() -> ((class_6880)holder).comp_349(), () -> holder);
    }

    @Override
    public void registerCommand(LiteralArgumentBuilder<class_2168> literalArgumentBuilder) {
        this.literalArgumentBuilders.add(literalArgumentBuilder);
    }

    @Override
    public void registerAzureLibIdentity(Supplier<? extends class_1792> itemSupplier) {
        AzIdentityRegistry.register((class_1792)itemSupplier.get(), (class_1792[])new class_1792[0]);
    }

    @Override
    public void registerCompostableItem(Supplier<? extends class_1935> itemLikeSupplier, float chance, boolean villagersCanCompost, boolean replace) {
        CompostingChanceRegistry.INSTANCE.add(itemLikeSupplier.get(), (Object)Float.valueOf(chance));
    }

    @Override
    public void registerEntityAttributes(Supplier<? extends class_1299<? extends class_1309>> entityTypeSupplier, Supplier<class_5132.class_5133> attributeSupplierBuilderSupplier) {
        FabricDefaultAttributeRegistry.register(entityTypeSupplier.get(), (class_5132.class_5133)attributeSupplierBuilderSupplier.get());
    }

    @Override
    public <T extends class_1308> void registerEntitySpawnData(AVPEntitySpawnData<T> spawnData) {
        AVPConfig.SpawnConfigs.SpawnSettings spawnSettings = spawnData.getConfigData().spawnSettings();
        class_1299<T> entityType = spawnData.getEntityType();
        if (!spawnData.isPlacementDisabled()) {
            class_9168 placement = spawnData.getPlacementData().type();
            class_2902.class_2903 heightMap = spawnData.getPlacementData().heightmapType();
            class_1317.class_4306<T> spawnPredicate = spawnData.getPlacementData().spawnPredicate();
            class_1317.method_20637(entityType, (class_9168)placement, (class_2902.class_2903)heightMap, spawnPredicate);
        }
        if (!spawnData.isConfigDisabled()) {
            Predicate<BiomeSelectionContext> biomeSelector = biomeSelectionContext -> biomeSelectionContext.hasTag(spawnData.getConfigData().biomeTagKey());
            class_1311 spawnGroup = entityType.method_5891();
            int weight = spawnSettings.weight;
            int minGroupSize = spawnSettings.minGroupSize;
            int maxGroupSize = spawnSettings.maxGroupSize;
            BiomeModifications.addSpawn(biomeSelector, (class_1311)spawnGroup, entityType, (int)weight, (int)minGroupSize, (int)maxGroupSize);
        }
    }

    @Override
    public void registerFurnaceFuel(Supplier<? extends class_1935> itemLikeSupplier, int burnTimeInTicks) {
        FuelRegistry.INSTANCE.add(itemLikeSupplier.get(), (Object)burnTimeInTicks);
    }

    @Override
    public <T extends class_8710> void registerPacketHandlers(NetworkHandler<T> networkHandler) {
        NetworkHandler<T> networkHandler2 = networkHandler;
        Objects.requireNonNull(networkHandler2);
        NetworkHandler<T> networkHandler3 = networkHandler2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NetworkHandler.FromClient.class, NetworkHandler.FromEither.class, NetworkHandler.FromServer.class}, networkHandler3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                NetworkHandler.FromClient handler = (NetworkHandler.FromClient)networkHandler3;
                ServerPlayNetworking.registerGlobalReceiver(networkHandler.type(), (payload, context) -> context.server().execute(() -> handler.payloadConsumer().accept(payload, (class_1657)context.player())));
                break;
            }
            case 1: {
                NetworkHandler.FromEither handler = (NetworkHandler.FromEither)networkHandler3;
                ServerPlayNetworking.registerGlobalReceiver(networkHandler.type(), (payload, context) -> context.server().execute(() -> handler.fromClientPayloadConsumer().accept(payload, (class_1657)context.player())));
                this.clientBoundPacketHandlers.add(networkHandler);
                break;
            }
            case 2: {
                NetworkHandler.FromServer handler = (NetworkHandler.FromServer)networkHandler3;
                this.clientBoundPacketHandlers.add(networkHandler);
            }
        }
    }

    @Override
    public <T extends class_8710> void registerPacketDirection(PacketDirection<T> packetDirection) {
        boolean handleClient = false;
        boolean handleServer = false;
        JustStreamCodecToMojangStreamCodecAdapter<T> codec = new JustStreamCodecToMojangStreamCodecAdapter<T>(packetDirection.codec());
        class_8710.class_9154<T> type = packetDirection.type();
        PacketDirection<T> packetDirection2 = packetDirection;
        Objects.requireNonNull(packetDirection2);
        PacketDirection<T> packetDirection3 = packetDirection2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PacketDirection.BI.class, PacketDirection.C2S.class, PacketDirection.S2C.class}, packetDirection3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                PacketDirection.BI ignored = (PacketDirection.BI)packetDirection3;
                handleClient = true;
                handleServer = true;
                break;
            }
            case 1: {
                PacketDirection.C2S ignored = (PacketDirection.C2S)packetDirection3;
                handleServer = true;
                break;
            }
            case 2: {
                PacketDirection.S2C ignored = (PacketDirection.S2C)packetDirection3;
                handleClient = true;
            }
        }
        if (handleClient) {
            PayloadTypeRegistry.playS2C().register(type, codec);
        }
        if (handleServer) {
            PayloadTypeRegistry.playC2S().register(type, codec);
        }
    }

    @Override
    public class_3302 registerReloadListener(final String id, final class_3302 listener) {
        IdentifiableResourceReloadListener adaptedListener = new IdentifiableResourceReloadListener(){

            public class_2960 getFabricId() {
                return AVPResources.location(id);
            }

            @NotNull
            public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
                return listener.method_25931(preparationBarrier, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor);
            }
        };
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener(adaptedListener);
        return listener;
    }

    @Override
    public void registerVillagerTrade(Supplier<class_3852> villagerProfessionSupplier, int level, List<class_3853.class_1652> villagerTradeItemListings) {
        TradeOfferHelper.registerVillagerOffers((class_3852)villagerProfessionSupplier.get(), (int)level, factories -> factories.addAll(villagerTradeItemListings));
    }

    public List<NetworkHandler<?>> getClientBoundPacketHandlers() {
        return this.clientBoundPacketHandlers;
    }

    public List<LiteralArgumentBuilder<class_2168>> getLiteralArgumentBuilders() {
        return this.literalArgumentBuilders;
    }

    private static /* synthetic */ class_6880 lambda$register$0(class_6880 holder) {
        return holder;
    }
}

