/*
 * Decompiled with CFR 0.152.
 */
package com.avp.mixin;

import com.alien.common.util.AcidBleedUtil;
import com.avp.common.registry.init.AVPDataKeys;
import com.lib.common.gameplay.entity.manager.GeneManager;
import com.lib.common.gameplay.gene.GeneOperationType;
import com.lib.common.gameplay.gene.Genes;
import com.lib.common.model.GeneCarrier;
import com.lib.common.network.DataAccessor;
import com.lib.common.network.DataUser;
import com.lib.common.util.GeneResistanceHurtUtil;
import com.lib.common.util.TeleportUtil;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_8103;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class MixinLivingEntity_GeneCarrier
extends class_1297
implements GeneCarrier,
DataUser {
    @Unique
    private final DataAccessor<Boolean> avp$hasWarpEffect = new DataAccessor<Boolean>(this, AVPDataKeys.ENTITY_HAS_WARP_EFFECT);
    @Unique
    private GeneManager avp$geneManager;

    public MixinLivingEntity_GeneCarrier(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    public void tick(CallbackInfo callbackInfo) {
        GeneManager geneManager = this.getOrCreateGeneManager();
        geneManager.tick();
        if (this.method_37908().field_9236 && this.avp$hasWarpEffect.get().booleanValue()) {
            for (int i = 0; i < 2; ++i) {
                this.method_37908().method_8406((class_2394)class_2398.field_11214, this.method_23322(0.5), this.method_23319() - 0.25, this.method_23325(0.5), (this.field_5974.method_43058() - 0.5) * 2.0, -this.field_5974.method_43058(), (this.field_5974.method_43058() - 0.5) * 2.0);
            }
        }
        if (!this.method_37908().field_9236) {
            this.avp$hasWarpEffect.set(this.avp$hasWarpGene());
        }
    }

    @ModifyVariable(method={"hurt"}, at=@At(value="HEAD"), index=2, argsOnly=true)
    private float avp$hurt(float originalDamage, class_1282 damageSource) {
        return GeneResistanceHurtUtil.applyResistancesToDamage(this, damageSource, originalDamage);
    }

    @Inject(at={@At(value="HEAD")}, method={"hurt"}, cancellable=true)
    public void avp$hurt(class_1282 damageSource, float damage, CallbackInfoReturnable<Boolean> cir) {
        if (damage == 0.0f) {
            cir.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"hurt"}, cancellable=true)
    public void avp$preHurtEffects(class_1282 damageSource, float damage, CallbackInfoReturnable<Boolean> cir) {
        if (!this.avp$hasWarpEffect.get().booleanValue()) {
            return;
        }
        double warpStrength = this.getOrCreateGeneManager().getGeneContainer().getActiveGeneMap().getValue(Genes.WARP, GeneOperationType.ADDITIVE);
        if (this.shouldTeleportToDodgeProjectile(damageSource, warpStrength) || this.shouldTeleportRandomly(warpStrength)) {
            class_1309 self = (class_1309)class_1309.class.cast(this);
            for (int i = 0; i < 64; ++i) {
                if (!TeleportUtil.teleport(self)) continue;
                cir.setReturnValue((Object)false);
                return;
            }
        }
    }

    private boolean shouldTeleportRandomly(double warpStrength) {
        double randomTeleportPoolSizeMultiplier = Math.clamp(1.1 - warpStrength, 0.0, 1.0);
        int randomTeleportPoolSize = (int)(100.0 * randomTeleportPoolSizeMultiplier);
        return this.field_5974.method_43048(randomTeleportPoolSize) == 0;
    }

    private boolean shouldTeleportToDodgeProjectile(class_1282 damageSource, double warpStrength) {
        double projectileTeleportPoolSizeMultiplier = Math.clamp(1.1 - warpStrength, 0.0, 1.0);
        int projectileTeleportPoolSize = (int)(10.0 * projectileTeleportPoolSizeMultiplier);
        return damageSource.method_48789(class_8103.field_42247) && this.field_5974.method_43048(projectileTeleportPoolSize) == 0;
    }

    @Inject(at={@At(value="RETURN")}, method={"hurt"})
    public void avp$postHurtEffects(class_1282 damageSource, float damage, CallbackInfoReturnable<Boolean> cir) {
        boolean isHurt = cir.getReturnValueZ();
        if (isHurt) {
            this.avp$handleAcidBloodGene(damageSource, damage);
            this.avp$handlePoisonousBarbsGene(damageSource, damage);
            this.avp$handleThornsGene(damageSource, damage);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"isSensitiveToWater"}, cancellable=true)
    public void avp$isSensitiveToWater(CallbackInfoReturnable<Boolean> cir) {
        boolean isSensitiveToWater = cir.getReturnValueZ();
        cir.setReturnValue((Object)(isSensitiveToWater || this.avp$hasWarpGene() ? 1 : 0));
    }

    @Unique
    private boolean avp$hasWarpGene() {
        return this.getOrCreateGeneManager().getGeneContainer().getActiveGeneMap().hasGene(Genes.WARP);
    }

    @Unique
    private void avp$handleAcidBloodGene(class_1282 damageSource, float damage) {
        double acidBloodChance = this.getOrCreateGeneManager().getGeneContainer().getActiveGeneMap().getValue(Genes.ACIDIC_BLOOD, GeneOperationType.MULTIPLICATIVE);
        if (this.method_59922().method_43058() < acidBloodChance && damageSource != this.method_48923().method_51847()) {
            class_1309 self = (class_1309)class_1309.class.cast(this);
            class_243 randomPos = AcidBleedUtil.computeRandomPosFromBoundingBox(self);
            AcidBleedUtil.spawnAcid(self, damage, randomPos);
        }
    }

    @Unique
    private void avp$handlePoisonousBarbsGene(class_1282 damageSource, float damage) {
        class_1297 class_12972;
        if (!damageSource.method_48789(class_8103.field_42260) && (class_12972 = damageSource.method_5526()) instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            double poisonChance = this.getOrCreateGeneManager().getGeneContainer().getActiveGeneMap().getValue(Genes.POISONOUS_BARBS, GeneOperationType.MULTIPLICATIVE);
            if (this.method_59922().method_43058() < poisonChance) {
                livingEntity.method_37222(new class_1293(class_1294.field_5899, 120, 0), (class_1297)this);
            }
        }
    }

    @Unique
    private void avp$handleThornsGene(class_1282 damageSource, float damage) {
        class_1297 class_12972;
        if (!damageSource.method_48789(class_8103.field_42260) && (class_12972 = damageSource.method_5526()) instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            double thornsDamage = this.getOrCreateGeneManager().getGeneContainer().getActiveGeneMap().getValue(Genes.THORNS, GeneOperationType.ADDITIVE);
            if (thornsDamage >= 0.0) {
                livingEntity.method_5643(livingEntity.method_48923().method_48818((class_1297)this), (float)thornsDamage);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"readAdditionalSaveData"})
    public void readAdditionalSaveData(class_2487 compoundTag, CallbackInfo callbackInfo) {
        this.getOrCreateGeneManager().load(compoundTag);
    }

    @Inject(at={@At(value="HEAD")}, method={"addAdditionalSaveData"})
    public void addAdditionalSaveData(class_2487 compoundTag, CallbackInfo callbackInfo) {
        this.getOrCreateGeneManager().save(compoundTag);
    }

    @Override
    public GeneManager getOrCreateGeneManager() {
        if (this.avp$geneManager == null) {
            class_1309 self = (class_1309)class_1309.class.cast(this);
            this.avp$geneManager = new GeneManager(self);
        }
        return this.avp$geneManager;
    }

    @Override
    public void setGeneManager(GeneManager geneManager) {
        this.avp$geneManager = geneManager;
    }
}

