/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.block.entity.power;

import com.avp.AVP;
import com.human.common.gameplay.power.PowerNode;
import com.human.common.gameplay.power.PowerSystem;
import com.human.common.gameplay.power.grid.PowerGridExploreUtil;
import com.human.common.gameplay.power.grid.PowerGridManager;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public abstract class PowerNodeBlockEntity
extends class_2586 {
    private boolean hasInitialized = false;
    private final PowerNode powerNode;

    public PowerNodeBlockEntity(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        super(type, pos, blockState);
        PowerNodeBlockEntity powerNodeBlockEntity = this;
        if (!(powerNodeBlockEntity instanceof PowerNode)) {
            throw new IllegalStateException("Child of PowerNodeBlockEntity must be instance of PowerNode!");
        }
        PowerNode node = (PowerNode)((Object)powerNodeBlockEntity);
        this.powerNode = node;
    }

    public void serverTick(class_1937 level, class_2338 blockPos, class_2680 blockState) {
        if (!this.hasInitialized() && level != null && !level.field_9236) {
            this.setHasInitialized(true);
            class_3218 serverLevel = (class_3218)level;
            PowerGridManager manager = PowerSystem.get(serverLevel);
            manager.registerNode(blockPos, this.powerNode);
            AVP.LOGGER.debug("Starting BFS for PNBE at pos {}", (Object)blockPos);
            long start = System.currentTimeMillis();
            Set<class_2338> connectedPositions = PowerGridExploreUtil.discover((class_1937)serverLevel, blockPos);
            AVP.LOGGER.debug("Finished BFS for PNBE at pos {} in {}ms", (Object)blockPos, (Object)(System.currentTimeMillis() - start));
            for (class_2338 pos : connectedPositions) {
                manager.union(blockPos, pos);
            }
        }
    }

    public void method_11012() {
        class_1937 level;
        if (!this.method_11015() && (level = this.method_10997()) != null && !level.field_9236) {
            PowerSystem.get((class_3218)level).unregisterNode(this.field_11867, this.powerNode);
        }
        super.method_11012();
    }

    public void setHasInitialized(boolean hasInitialized) {
        this.hasInitialized = hasInitialized;
    }

    public boolean hasInitialized() {
        return this.hasInitialized;
    }
}

