/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.block.power;

import com.human.common.gameplay.power.PowerNode;
import com.human.common.gameplay.power.PowerSystem;
import com.human.common.gameplay.power.grid.PowerGridManager;
import com.lib.common.util.DirectionUtil;
import java.util.Map;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;

public class CableBlock
extends class_2248 {
    public static final class_2746 NORTH = class_2741.field_12489;
    public static final class_2746 SOUTH = class_2741.field_12540;
    public static final class_2746 EAST = class_2741.field_12487;
    public static final class_2746 WEST = class_2741.field_12527;
    public static final class_2746 UP = class_2741.field_12519;
    public static final class_2746 DOWN = class_2741.field_12546;
    public static final Map<class_2350, class_2746> PROPERTY_BY_DIRECTION = Map.of(class_2350.field_11043, NORTH, class_2350.field_11035, SOUTH, class_2350.field_11034, EAST, class_2350.field_11039, WEST, class_2350.field_11036, UP, class_2350.field_11033, DOWN);
    private static final class_265 CORE = CableBlock.method_9541((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final class_265 SIDE_NORTH = CableBlock.method_9541((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0);
    private static final class_265 SIDE_SOUTH = CableBlock.method_9541((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0);
    private static final class_265 SIDE_EAST = CableBlock.method_9541((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static final class_265 SIDE_WEST = CableBlock.method_9541((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0);
    private static final class_265 SIDE_UP = CableBlock.method_9541((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final class_265 SIDE_DOWN = CableBlock.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
    private static final class_265[] SHAPES_BY_MASK = CableBlock.makeShapes();

    private static class_265[] makeShapes() {
        class_265[] voxelShapes = new class_265[64];
        for (int mask = 0; mask < 64; ++mask) {
            class_265 voxelShape = CORE;
            if ((mask & 1) != 0) {
                voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)SIDE_NORTH);
            }
            if ((mask & 2) != 0) {
                voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)SIDE_SOUTH);
            }
            if ((mask & 4) != 0) {
                voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)SIDE_EAST);
            }
            if ((mask & 8) != 0) {
                voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)SIDE_WEST);
            }
            if ((mask & 0x10) != 0) {
                voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)SIDE_UP);
            }
            if ((mask & 0x20) != 0) {
                voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)SIDE_DOWN);
            }
            voxelShapes[mask] = voxelShape.method_1097();
        }
        return voxelShapes;
    }

    private static int maskFromState(class_2680 s) {
        int mask = 0;
        if (((Boolean)s.method_11654((class_2769)NORTH)).booleanValue()) {
            mask |= 1;
        }
        if (((Boolean)s.method_11654((class_2769)SOUTH)).booleanValue()) {
            mask |= 2;
        }
        if (((Boolean)s.method_11654((class_2769)EAST)).booleanValue()) {
            mask |= 4;
        }
        if (((Boolean)s.method_11654((class_2769)WEST)).booleanValue()) {
            mask |= 8;
        }
        if (((Boolean)s.method_11654((class_2769)UP)).booleanValue()) {
            mask |= 0x10;
        }
        if (((Boolean)s.method_11654((class_2769)DOWN)).booleanValue()) {
            mask |= 0x20;
        }
        return mask;
    }

    public CableBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)UP, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public class_2680 method_9605(class_1750 context) {
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2680 state = this.method_9564();
        for (class_2350 direction : DirectionUtil.VALUES) {
            class_2338 neighborPos = pos.method_10093(direction);
            state = (class_2680)state.method_11657((class_2769)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(this.canConnectTo((class_1936)level, neighborPos)));
        }
        return state;
    }

    @NotNull
    public class_2680 method_9559(class_2680 state, @NotNull class_2350 direction, @NotNull class_2680 neighborState, @NotNull class_1936 level, @NotNull class_2338 pos, @NotNull class_2338 neighborPos) {
        return (class_2680)state.method_11657((class_2769)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(this.canConnectTo(level, neighborPos)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{NORTH, SOUTH, EAST, WEST, UP, DOWN});
    }

    @NotNull
    public class_265 method_9530(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_3726 ctx) {
        return SHAPES_BY_MASK[CableBlock.maskFromState(state)];
    }

    @NotNull
    public class_265 method_9549(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_3726 ctx) {
        return SHAPES_BY_MASK[CableBlock.maskFromState(state)];
    }

    @NotNull
    public class_265 method_9571(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos) {
        return SHAPES_BY_MASK[CableBlock.maskFromState(state)];
    }

    public boolean method_9579(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos) {
        return true;
    }

    public int method_9505(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos) {
        return 0;
    }

    public boolean method_9526(@NotNull class_2680 state) {
        return true;
    }

    protected void method_9615(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 blockPos, @NotNull class_2680 oldState, boolean movedByPiston) {
        super.method_9615(state, level, blockPos, oldState, movedByPiston);
        if (level.field_9236) {
            return;
        }
        PowerGridManager manager = PowerSystem.get((class_3218)level);
        for (class_2350 direction : DirectionUtil.VALUES) {
            class_2338 neighbor = blockPos.method_10093(direction);
            if (!this.canConnectTo((class_1936)level, neighbor)) continue;
            manager.union(blockPos, neighbor);
        }
    }

    protected void method_9536(@NotNull class_2680 state, class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 newState, boolean movedByPiston) {
        if (!level.field_9236 && state.method_26204() != newState.method_26204()) {
            PowerSystem.get((class_3218)level).splitGrid(level, pos);
        }
        super.method_9536(state, level, pos, newState, movedByPiston);
    }

    private boolean canConnectTo(class_1936 level, class_2338 neighbor) {
        return this.canConnectTo(level, neighbor, level.method_8320(neighbor));
    }

    private boolean canConnectTo(class_1936 level, class_2338 neighbor, class_2680 neighborState) {
        return neighborState.method_26204() instanceof CableBlock || level.method_8321(neighbor) instanceof PowerNode;
    }
}

