/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.entity.living.human.marine.ai;

import com.human.common.gameplay.entity.living.human.marine.Marine;
import com.human.common.gameplay.entity.living.human.marine.ai.MarineRangedAttackAction;
import com.human.common.gameplay.item.GunItem;
import com.human.common.gameplay.item.gun.FireModeConfig;
import com.lib.common.gameplay.entity.ai.EntityGOAP;
import com.lib.common.gameplay.entity.ai.GOAPConstants;
import com.lib.common.gameplay.entity.ai.action.AttackAction;
import com.lib.common.gameplay.entity.ai.action.AvoidAction;
import com.lib.common.gameplay.entity.ai.action.EatFoodToHealAction;
import com.lib.common.gameplay.entity.ai.action.EquipItemAction;
import com.lib.common.gameplay.entity.ai.action.MoveToTargetEntityAction;
import com.lib.common.gameplay.entity.ai.action.PickUpItemAction;
import com.lib.common.gameplay.entity.ai.action.WanderToLandPosAction;
import com.lib.common.gameplay.entity.ai.goal.EntertainedGoal;
import com.lib.common.gameplay.entity.ai.goal.HealthyGoal;
import com.lib.common.gameplay.entity.ai.goal.NoTargetGoal;
import com.lib.common.gameplay.entity.ai.goal.PickUpFoodGoal;
import com.lib.common.gameplay.entity.ai.sensor.combat.CombatResponseSensor;
import com.lib.common.gameplay.entity.ai.sensor.combat.NearbyAttackTargetEntitiesSensor;
import com.lib.common.gameplay.entity.ai.sensor.combat.NearestAttackTargetEntitySensor;
import com.lib.common.gameplay.entity.ai.sensor.combat.NearestAttackTargetInRangeSensor;
import com.lib.common.gameplay.entity.ai.sensor.entity.FoodTargetEntityInRangeSensor;
import com.lib.common.gameplay.entity.ai.sensor.entity.NearbyEntitiesSensor;
import com.lib.common.gameplay.entity.ai.sensor.entity.NearbyFoodItemEntitiesSensor;
import com.lib.common.gameplay.entity.ai.sensor.entity.NearbyItemEntitiesSensor;
import com.lib.common.gameplay.entity.ai.sensor.entity.NearbyLivingEntitiesSensor;
import com.lib.common.gameplay.entity.ai.sensor.entity.NearestFoodItemEntitySensor;
import com.lib.common.gameplay.entity.ai.sensor.inventory.InventorySensor;
import com.lib.common.gameplay.entity.ai.sensor.stats.IsBoredSensor;
import com.lib.common.gameplay.entity.ai.sensor.stats.IsHealthySensor;
import com.lib.common.gameplay.entity.ai.util.CombatResponse;
import com.lib.common.gameplay.entity.ai.util.ItemType;
import com.lib.common.gameplay.goap.state.GOAPWorldState;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1588;
import net.minecraft.class_1792;

public class MarineGOAP
extends EntityGOAP<Marine> {
    public MarineGOAP(Marine marine) {
        this.addBaseRoutines(marine);
        this.addInventoryRoutines();
        this.addFoodPickupRoutines(marine);
        this.addCombatRoutines(marine);
        this.addSelfCareRoutines(marine);
    }

    public void addBaseRoutines(Marine marine) {
        this.addSensor(NearbyEntitiesSensor.INSTANCE);
        this.addSensor(NearbyLivingEntitiesSensor.INSTANCE);
        this.addSensor(NearbyItemEntitiesSensor.INSTANCE);
        this.addSensor(new IsBoredSensor(marine.method_59922()));
        this.addAction(new WanderToLandPosAction(0.75));
        this.addGoal(new EntertainedGoal());
    }

    public void addInventoryRoutines() {
        this.addSensor(new InventorySensor());
    }

    public void addFoodPickupRoutines(Marine marine) {
        this.addSensor(NearbyFoodItemEntitiesSensor.INSTANCE);
        this.addSensor(NearestFoodItemEntitySensor.INSTANCE);
        this.addSensor(new FoodTargetEntityInRangeSensor<Marine>((self, distanceSqr) -> distanceSqr <= 4.0));
        this.addGoal(new PickUpFoodGoal());
        this.addAction(new MoveToTargetEntityAction(GOAPConstants.NEAREST_FOOD_ITEM_ENTITY, GOAPConstants.IS_FOOD_TARGET_ITEM_ENTITY_IN_RANGE, 1.0, (self, distanceSqr) -> distanceSqr < 1.0));
        this.addAction(new PickUpItemAction(GOAPConstants.NEAREST_FOOD_ITEM_ENTITY, GOAPConstants.IS_FOOD_TARGET_ITEM_ENTITY_IN_RANGE, worldState -> Float.valueOf(marine.method_6032() / marine.method_6063())));
    }

    public void addCombatRoutines(Marine marine) {
        this.addSensor(new NearbyAttackTargetEntitiesSensor(target -> target instanceof class_1588));
        this.addSensor(NearestAttackTargetEntitySensor.INSTANCE);
        this.addSensor(new NearestAttackTargetInRangeSensor((worldState, distanceSqr) -> this.isTargetInRange(marine, (GOAPWorldState)worldState, (double)distanceSqr)));
        this.addSensor(new CombatResponseSensor());
        this.addGoal(new NoTargetGoal());
        this.addAction(new MoveToTargetEntityAction(GOAPConstants.NEAREST_ATTACK_TARGET_ENTITY, GOAPConstants.IS_ATTACK_TARGET_ENTITY_IN_RANGE, 1.0, (worldState, distanceSqr) -> this.isTargetInRange(marine, (GOAPWorldState)worldState, (double)distanceSqr)));
        this.addAction(new EquipItemAction(class_1268.field_5808, ItemType.meleeWeapon()));
        this.addAction(new AttackAction(CombatResponse.FightType.MELEE));
        this.addAction(new EquipItemAction(class_1268.field_5808, ItemType.rangedWeapon()));
        this.addAction(new MarineRangedAttackAction());
        this.addAction(new AvoidAction(8, 1.2f));
    }

    public void addSelfCareRoutines(Marine marine) {
        this.addSensor(new IsHealthySensor(0.5f));
        this.addGoal(new HealthyGoal());
        this.addAction(new EquipItemAction(class_1268.field_5810, ItemType.food()));
        this.addAction(new EatFoodToHealAction(marine.method_6063() * 0.2f));
    }

    private boolean isTargetInRange(Marine marine, GOAPWorldState worldState, double distanceSqr) {
        ItemType itemType = worldState.getOrDefault(GOAPConstants.MAIN_HAND_ITEM_TYPE, ItemType.none());
        Objects.requireNonNull(itemType);
        ItemType itemType2 = itemType;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemType.MeleeWeapon.class, ItemType.RangedWeapon.class, ItemType.Food.class, ItemType.None.class, ItemType.Other.class}, (Object)itemType2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                ItemType.MeleeWeapon meleeWeapon = (ItemType.MeleeWeapon)itemType2;
                if (distanceSqr <= 4.0) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                ItemType.RangedWeapon rangedWeapon = (ItemType.RangedWeapon)itemType2;
                class_1792 var10_8 = marine.method_6047().method_7909();
                if (var10_8 instanceof GunItem) {
                    GunItem gunItem = (GunItem)var10_8;
                    FireModeConfig fireMode = gunItem.getGunConfig().getDefaultFireMode();
                    int range = fireMode.range();
                    if (distanceSqr < (double)(range * range)) {
                        yield true;
                    }
                    yield false;
                }
                if (distanceSqr < 256.0) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                ItemType.Food food = (ItemType.Food)itemType2;
                yield false;
            }
            case 3 -> {
                ItemType.None none = (ItemType.None)itemType2;
                yield false;
            }
            case 4 -> {
                ItemType.Other other = (ItemType.Other)itemType2;
                yield false;
            }
        };
    }
}

