/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.item;

import com.human.common.gameplay.component.SyringeContents;
import com.human.common.gameplay.component.SyringeMode;
import com.human.common.registry.init.HumanDataComponents;
import com.lib.common.gameplay.gene.GeneBonusDataEntry;
import com.lib.common.gameplay.gene.GeneModifierKey;
import com.lib.common.gameplay.gene.GeneOperationType;
import com.lib.common.gameplay.gene.Genes;
import com.lib.common.model.GeneCarrier;
import com.lib.common.registry.GeneBonusDataRegistry;
import com.lib.common.util.GeneDataUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5244;
import org.jetbrains.annotations.NotNull;

public class SyringeItem
extends class_1792 {
    private static final SyringeMode DEFAULT_SYRINGE_MODE = SyringeMode.EXTRACT;

    public SyringeItem() {
        super(new class_1792.class_1793().method_7889(1).method_57349(HumanDataComponents.SYRINGE_MODE.get(), (Object)DEFAULT_SYRINGE_MODE).method_7895(20));
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 level, @NotNull class_1657 player, @NotNull class_1268 hand) {
        SyringeMode mode;
        class_1799 stack = player.method_5998(hand);
        if (player.method_5715()) {
            if (!level.field_9236) {
                this.cycleSyringeMode(stack, player);
            }
            return class_1271.method_29237((Object)stack, (boolean)level.field_9236);
        }
        if (!level.field_9236 && (mode = (SyringeMode)((Object)stack.method_57825(HumanDataComponents.SYRINGE_MODE.get(), (Object)DEFAULT_SYRINGE_MODE))) == SyringeMode.EMPTY) {
            stack.method_57379(HumanDataComponents.SYRINGE_CONTENTS.get(), (Object)SyringeContents.EMPTY);
            player.method_7353((class_2561)class_2561.method_43470((String)"Syringe has been emptied."), true);
        }
        return super.method_7836(level, player, hand);
    }

    @NotNull
    public class_1269 method_7884(@NotNull class_1838 context) {
        class_1799 stack;
        SyringeMode mode;
        class_1657 player = context.method_8036();
        if (player == null) {
            return super.method_7884(context);
        }
        if (player.method_5715()) {
            if (!context.method_8045().method_8608()) {
                this.cycleSyringeMode(context.method_8041(), context.method_8036());
            }
            return class_1269.field_5812;
        }
        if (!context.method_8045().method_8608() && (mode = (SyringeMode)((Object)(stack = context.method_8041()).method_57825(HumanDataComponents.SYRINGE_MODE.get(), (Object)DEFAULT_SYRINGE_MODE))) == SyringeMode.EMPTY) {
            stack.method_57379(HumanDataComponents.SYRINGE_CONTENTS.get(), (Object)SyringeContents.EMPTY);
            player.method_7353((class_2561)class_2561.method_43470((String)"Syringe has been emptied."), true);
        }
        return super.method_7884(context);
    }

    private void cycleSyringeMode(class_1799 stack, class_1657 player) {
        SyringeMode current = (SyringeMode)((Object)stack.method_57825(HumanDataComponents.SYRINGE_MODE.get(), (Object)DEFAULT_SYRINGE_MODE));
        SyringeMode next = this.nextMode(current);
        stack.method_57379(HumanDataComponents.SYRINGE_MODE.get(), (Object)next);
        player.method_7353((class_2561)class_2561.method_43470((String)"Switched mode to ").method_10852((class_2561)class_2561.method_43470((String)next.toString()).method_27692(class_124.field_1054)), true);
    }

    private SyringeMode nextMode(SyringeMode current) {
        SyringeMode[] values = SyringeMode.values();
        int nextOrdinal = (current.ordinal() + 1) % values.length;
        return values[nextOrdinal];
    }

    public static void interact(@NotNull class_1799 stack, @NotNull class_1657 player, @NotNull class_1309 interactionTarget, @NotNull class_1268 usedHand) {
        SyringeContents syringeContents = (SyringeContents)stack.method_57825(HumanDataComponents.SYRINGE_CONTENTS.get(), (Object)SyringeContents.EMPTY);
        SyringeMode syringeMode = (SyringeMode)((Object)stack.method_57825(HumanDataComponents.SYRINGE_MODE.get(), (Object)DEFAULT_SYRINGE_MODE));
        switch (syringeMode) {
            case EMPTY: {
                stack.method_57379(HumanDataComponents.SYRINGE_CONTENTS.get(), (Object)SyringeContents.EMPTY);
                player.method_6122(usedHand, stack);
                break;
            }
            case EXTRACT: {
                Map<GeneModifierKey, Double> geneBonusMapData = GeneBonusDataRegistry.getOrDefault(interactionTarget.method_5864());
                if (geneBonusMapData.isEmpty()) {
                    return;
                }
                HashMap<GeneModifierKey, Double> currentGeneBonusMap = new HashMap<GeneModifierKey, Double>(GeneDataUtil.toMap(syringeContents.geneBonusDataEntries()));
                currentGeneBonusMap.putAll(geneBonusMapData);
                List<GeneBonusDataEntry> geneBonusDataEntries = currentGeneBonusMap.entrySet().stream().map(entry -> new GeneBonusDataEntry(((GeneModifierKey)entry.getKey()).resourceLocation(), ((GeneModifierKey)entry.getKey()).operation(), (Double)entry.getValue())).toList();
                stack.method_57379(HumanDataComponents.SYRINGE_CONTENTS.get(), (Object)new SyringeContents(geneBonusDataEntries));
                stack.method_7970(1, (class_1309)player, player.method_32326(stack));
                player.method_6122(usedHand, stack);
                interactionTarget.method_5643(interactionTarget.method_48923().method_48830(), 0.01f);
                player.method_7353((class_2561)class_2561.method_43470((String)"Extracted genes from target."), true);
                break;
            }
            case INJECT: {
                GeneCarrier geneCarrier = (GeneCarrier)interactionTarget;
                geneCarrier.getOrCreateGeneManager().getGeneContainer().getDormantGeneMap().putAll(GeneDataUtil.toMap(syringeContents.geneBonusDataEntries()));
                class_2960 resourceLocation = Genes.GENETIC_INTEGRITY.get().id();
                geneCarrier.getOrCreateGeneManager().getGeneContainer().getDormantGeneMap().add(resourceLocation, GeneOperationType.ADDITIVE, -0.34);
                stack.method_57379(HumanDataComponents.SYRINGE_CONTENTS.get(), (Object)SyringeContents.EMPTY);
                stack.method_7970(1, (class_1309)player, player.method_32326(stack));
                player.method_6122(usedHand, stack);
                interactionTarget.method_5643(interactionTarget.method_48923().method_48830(), 0.01f);
                player.method_7353((class_2561)class_2561.method_43470((String)"Injected target with genes."), true);
            }
        }
    }

    public void method_7851(@NotNull class_1799 itemStack, @NotNull class_1792.class_9635 tooltipContext, @NotNull List<class_2561> list, @NotNull class_1836 tooltipFlag) {
        super.method_7851(itemStack, tooltipContext, list, tooltipFlag);
        list.add((class_2561)class_2561.method_43470((String)"Shift + Right Click to change mode.").method_27692(class_124.field_1080));
        list.add(class_5244.field_39003);
        SyringeMode mode = (SyringeMode)((Object)itemStack.method_57825(HumanDataComponents.SYRINGE_MODE.get(), (Object)DEFAULT_SYRINGE_MODE));
        list.add((class_2561)class_2561.method_43470((String)"Current Mode: ").method_10852((class_2561)class_2561.method_43470((String)mode.toString()).method_27692(class_124.field_1054)));
        SyringeContents syringeContents = (SyringeContents)itemStack.method_57825(HumanDataComponents.SYRINGE_CONTENTS.get(), (Object)SyringeContents.EMPTY);
        if (syringeContents.equals(SyringeContents.EMPTY) || syringeContents.geneBonusDataEntries().isEmpty()) {
            return;
        }
        list.add(class_5244.field_39003);
        list.add((class_2561)class_2561.method_43470((String)"Genes:").method_27692(class_124.field_1054));
        list.add((class_2561)class_2561.method_43470((String)"???").method_27692(class_124.field_1080));
    }
}

