/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.item.canister;

import com.avp.common.registry.init.item.AVPItems;
import com.human.common.data.HumanAdvancements;
import com.human.common.registry.init.HumanDataComponents;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2402;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5328;
import net.minecraft.class_5633;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9326;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CanisterItem
extends class_1792
implements class_5633 {
    public final class_3611 content;
    public static final int MAX_CAPACITY = 8;

    public CanisterItem(class_3611 content, class_1792.class_1793 properties) {
        super(properties);
        this.content = content;
    }

    public void method_7851(@NotNull class_1799 stack, @NotNull class_1792.class_9635 context, @NotNull List<class_2561> tooltipComponents, @NotNull class_1836 tooltipFlag) {
        super.method_7851(stack, context, tooltipComponents, tooltipFlag);
        int currentContentAmount = (Integer)stack.method_57825(HumanDataComponents.CANISTER_CAPACITY.get(), (Object)0);
        if (currentContentAmount == 0) {
            return;
        }
        tooltipComponents.add((class_2561)class_2561.method_43471((String)"tooltip.avp.capacity").method_27693(currentContentAmount + "/8"));
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 level, class_1657 player, @NotNull class_1268 usedHand) {
        class_2350 hitDir;
        class_2338 relativePos;
        class_1799 canisterStack = player.method_5998(usedHand);
        class_3965 hitResult = CanisterItem.method_7872((class_1937)level, (class_1657)player, (class_3959.class_242)(this.isFluidPlacementAction(player) ? class_3959.class_242.field_1348 : class_3959.class_242.field_1345));
        if (CanisterItem.isInvalidHitResult(hitResult)) {
            return class_1271.method_22431((Object)canisterStack);
        }
        class_2338 hitPos = hitResult.method_17777();
        if (!CanisterItem.canPlayerInteract(level, player, hitPos, relativePos = hitPos.method_10093(hitDir = hitResult.method_17780()), hitDir, canisterStack)) {
            return class_1271.method_22431((Object)canisterStack);
        }
        class_2680 hitState = level.method_8320(hitPos);
        if (CanisterItem.isFluidPickupAction(player, hitState)) {
            return this.handleFluidPickup(player, level, canisterStack, hitPos, hitState);
        }
        if (this.isFluidPlacementAction(player)) {
            return this.handleFluidPlacement(player, level, canisterStack, hitResult, hitPos, hitState, relativePos);
        }
        return class_1271.method_22431((Object)canisterStack);
    }

    public static boolean isInvalidHitResult(class_3965 hitResult) {
        return hitResult.method_17783() == class_239.class_240.field_1333 || hitResult.method_17783() != class_239.class_240.field_1332;
    }

    public static boolean canPlayerInteract(class_1937 level, class_1657 player, class_2338 hitPos, class_2338 relativePos, class_2350 hitDir, class_1799 stack) {
        return level.method_8505(player, hitPos) && player.method_7343(relativePos, hitDir, stack);
    }

    public static boolean isFluidPickupAction(class_1657 player, class_2680 hitState) {
        return !player.method_5715() && hitState.method_26204() instanceof class_2263;
    }

    private boolean isFluidPlacementAction(class_1657 player) {
        return player.method_5715() && this.content != class_3612.field_15906;
    }

    private class_1271<class_1799> handleFluidPickup(class_1657 player, class_1937 level, class_1799 canisterStack, class_2338 hitPos, class_2680 hitState) {
        class_2263 bucketPickup = (class_2263)hitState.method_26204();
        if ((Integer)canisterStack.method_57825(HumanDataComponents.CANISTER_CAPACITY.get(), (Object)0) >= 8) {
            return class_1271.method_22431((Object)canisterStack);
        }
        class_1799 filledStack = this.pickupBlock(player, level, canisterStack, bucketPickup, hitPos, hitState);
        if (filledStack.method_7960()) {
            return class_1271.method_22431((Object)canisterStack);
        }
        player.method_7259(class_3468.field_15372.method_14956((Object)this));
        bucketPickup.method_32351().ifPresent(sound -> player.method_5783(sound, 1.0f, 1.0f));
        level.method_33596((class_1297)player, (class_6880)class_5712.field_28167, hitPos);
        class_1799 resultStack = this.content != class_3612.field_15906 ? CanisterItem.updateCapacity((class_1309)player, filledStack, 1) : class_5328.method_30012((class_1799)canisterStack, (class_1657)player, (class_1799)filledStack);
        if (!level.field_9236) {
            class_174.field_1208.method_8932((class_3222)player, filledStack);
        }
        return class_1271.method_29237((Object)resultStack, (boolean)level.method_8608());
    }

    private class_1271<class_1799> handleFluidPlacement(class_1657 player, class_1937 level, class_1799 canisterStack, class_3965 hitResult, class_2338 hitPos, class_2680 hitState, class_2338 relativePos) {
        class_2338 targetPos;
        class_2338 class_23382 = targetPos = hitState.method_26204() instanceof class_2402 && this.content == class_3612.field_15910 ? hitPos : relativePos;
        if (!this.method_7731(player, level, targetPos, hitResult)) {
            return class_1271.method_22431((Object)canisterStack);
        }
        this.method_7728(player, level, canisterStack, targetPos);
        if (player instanceof class_3222) {
            class_174.field_1191.method_23889((class_3222)player, targetPos, canisterStack);
        }
        player.method_7259(class_3468.field_15372.method_14956((Object)this));
        class_1799 resultStack = (Integer)canisterStack.method_57825(HumanDataComponents.CANISTER_CAPACITY.get(), (Object)0) > 1 && !player.method_7337() ? CanisterItem.updateCapacity((class_1309)player, canisterStack, -1) : class_5328.method_30012((class_1799)canisterStack, (class_1657)player, (class_1799)CanisterItem.getEmptySuccessItem(canisterStack, player));
        return class_1271.method_29237((Object)resultStack, (boolean)level.method_8608());
    }

    public static class_1799 updateCapacity(class_1309 livingEntity, class_1799 stack, int amount) {
        int currentContentAmount = (Integer)stack.method_57825(HumanDataComponents.CANISTER_CAPACITY.get(), (Object)0);
        int newAmount = class_3532.method_15340((int)(currentContentAmount + amount), (int)0, (int)8);
        if (newAmount >= 8 && livingEntity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)livingEntity;
            HumanAdvancements.FILL_CANISTER.grant(serverPlayer);
        }
        stack.method_57366(class_9326.method_57841().method_57854(HumanDataComponents.CANISTER_CAPACITY.get(), (Object)newAmount).method_57852());
        return stack;
    }

    private class_1799 pickupBlock(class_1657 player, class_1937 level, class_1799 canisterStack, class_2263 bucketPickup, class_2338 blockPos, class_2680 blockState) {
        class_1799 bucketItem = bucketPickup.method_9700(player, (class_1936)level, blockPos, blockState);
        if (this.content != class_3612.field_15906) {
            return canisterStack;
        }
        if (bucketItem.method_31574(class_1802.field_8705)) {
            return new class_1799((class_1935)AVPItems.WATER_CANISTER.get());
        }
        if (bucketItem.method_31574(class_1802.field_8187)) {
            return new class_1799((class_1935)AVPItems.LAVA_CANISTER.get());
        }
        if (bucketItem.method_31574(class_1802.field_27876)) {
            return new class_1799((class_1935)AVPItems.POWDER_SNOW_CANISTER.get());
        }
        return canisterStack;
    }

    public static class_1799 getEmptySuccessItem(class_1799 canisterStack, class_1657 player) {
        return !player.method_56992() ? new class_1799((class_1935)AVPItems.CANISTER.get()) : canisterStack;
    }

    public boolean method_7731(@Nullable class_1657 player, @NotNull class_1937 level, @NotNull class_2338 pos, @Nullable class_3965 result) {
        class_2402 liquidBlockContainer;
        class_3611 class_36112 = this.content;
        if (!(class_36112 instanceof class_3609)) {
            return false;
        }
        class_3609 flowingFluid = (class_3609)class_36112;
        class_2680 blockState = level.method_8320(pos);
        class_2248 block = blockState.method_26204();
        boolean isReplaceable = blockState.method_26188(this.content);
        boolean canEmptyHere = !blockState.method_26215() && !isReplaceable ? block instanceof class_2402 && (liquidBlockContainer = (class_2402)block).method_10310(player, (class_1922)level, pos, blockState, this.content) : true;
        if (!canEmptyHere) {
            return result != null && this.method_7731(player, level, result.method_17777().method_10093(result.method_17780()), null);
        }
        if (level.method_8597().comp_644() && this.content.method_15791(class_3486.field_15517)) {
            int x = pos.method_10263();
            int y = pos.method_10264();
            int z = pos.method_10260();
            level.method_8396(player, pos, class_3417.field_15102, class_3419.field_15245, 0.5f, 2.6f + (level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.8f);
            for (int i = 0; i < 8; ++i) {
                level.method_8406((class_2394)class_2398.field_11237, (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        if (block instanceof class_2402) {
            liquidBlockContainer = (class_2402)block;
            if (this.content == class_3612.field_15910) {
                liquidBlockContainer.method_10311((class_1936)level, pos, blockState, flowingFluid.method_15729(false));
                this.playEmptySound(player, (class_1936)level, pos);
                return true;
            }
        }
        if (!level.field_9236 && isReplaceable && !blockState.method_51176()) {
            level.method_22352(pos, true);
        }
        if (!level.method_8652(pos, this.content.method_15785().method_15759(), 11) && !blockState.method_26227().method_15771()) {
            return false;
        }
        this.playEmptySound(player, (class_1936)level, pos);
        return true;
    }

    protected void playEmptySound(@Nullable class_1657 player, class_1936 level, class_2338 pos) {
        class_3414 soundEvent = this.content.method_15791(class_3486.field_15518) ? class_3417.field_15010 : class_3417.field_14834;
        level.method_8396(player, pos, soundEvent, class_3419.field_15245, 1.0f, 1.0f);
        level.method_33596((class_1297)player, (class_6880)class_5712.field_28166, pos);
    }
}

