/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.item.gun.pipeline;

import com.avp.common.util.AVPPredicates;
import com.avp.common.util.GunLightUtil;
import com.human.common.gameplay.item.GunItem;
import com.human.common.gameplay.item.gun.FireModeConfig;
import com.human.common.gameplay.item.gun.GunConfig;
import com.human.common.gameplay.item.gun.attack.GunAttackConfig;
import com.human.common.gameplay.item.gun.pipeline.GunShootResult;
import com.human.common.gameplay.item.gun.pipeline.step.GunShootStep;
import com.human.common.gameplay.item.gun.pipeline.step.impl.CheckCooldownStep;
import com.human.common.gameplay.item.gun.pipeline.step.impl.CheckReloadingStep;
import com.human.common.gameplay.item.gun.pipeline.step.impl.CheckShootDelayStep;
import com.human.common.registry.init.HumanDataComponents;
import com.just.core.functional.option.None;
import com.just.core.functional.option.Option;
import com.lib.common.gameplay.util.EnchantmentUtil;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5321;

public record GunShootContext(int currentAmmunition, FireModeConfig fireModeConfig, GunConfig gunConfig, GunItem gunItem, boolean hasInfinity, boolean isFirstTick, boolean isShooterImmortal, class_1799 itemStack, class_1309 shooter, int tickProgress) {
    private static final List<GunShootStep> STEPS = List.of(CheckShootDelayStep.INSTANCE, CheckCooldownStep.INSTANCE, CheckReloadingStep.INSTANCE);

    public GunShootContext(class_1309 shooter, GunItem gunItem, class_1799 itemStack, int tickProgress) {
        this((Integer)itemStack.method_57825(HumanDataComponents.AMMUNITION.get(), (Object)0), gunItem.getGunConfig().getDefaultFireMode(), gunItem.getGunConfig(), gunItem, EnchantmentUtil.getLevel(shooter.method_37908(), itemStack, (class_5321<class_1887>)class_1893.field_9125) > 0, tickProgress == 0, AVPPredicates.IS_IMMORTAL.test(shooter), itemStack, shooter, tickProgress);
    }

    public static Option<GunShootContext> create(class_1309 shooter, class_1799 itemStack, int tickProgress) {
        None none;
        class_1792 class_17922 = itemStack.method_7909();
        if (!(class_17922 instanceof GunItem)) {
            none = Option.none();
        } else {
            GunItem gunItem = (GunItem)class_17922;
            none = Option.some((Object)new GunShootContext(shooter, gunItem, itemStack, tickProgress));
        }
        return none;
    }

    public GunShootResult shoot() {
        for (GunShootStep step : STEPS) {
            GunShootResult result = step.apply(this);
            if (result == GunShootResult.CONTINUE) continue;
            return result;
        }
        GunAttackConfig gunAttackConfig = new GunAttackConfig(this.gunConfig, this.fireModeConfig, this.shooter, this.itemStack);
        GunShootResult result = this.fireModeConfig.gunAttackAction().shoot(gunAttackConfig);
        this.runPostEffects();
        return result;
    }

    private void runPostEffects() {
        if (this.shooter.method_37908().field_9236) {
            return;
        }
        GunLightUtil.spawnLightSource((class_1297)this.shooter);
        this.consumeAmmunition();
        this.updateItemStackDamage();
        this.playSecondaryShootSoundEffect();
        this.playPrimaryShootSoundEffects();
        class_1309 class_13092 = this.shooter;
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            player.method_7357().method_7906((class_1792)this.gunItem, this.fireModeConfig.cooldownInTicks());
        }
    }

    private void consumeAmmunition() {
        if (!this.isShooterImmortal && !this.hasInfinity) {
            this.itemStack.method_57379(HumanDataComponents.AMMUNITION.get(), (Object)Math.max(this.currentAmmunition - this.fireModeConfig.consumedAmmunitionPerShot(), 0));
        }
    }

    private void updateItemStackDamage() {
        if (!this.isShooterImmortal) {
            this.itemStack.method_7970(1, this.shooter, class_1304.field_6173);
        }
    }

    private void playSecondaryShootSoundEffect() {
        class_1937 level = this.shooter.method_37908();
        int shootDelayInTicks = this.fireModeConfig.shootDelayInTicks();
        int secondaryShootSoundFrequencyInTicks = this.fireModeConfig.secondaryShootSoundFrequencyInTicks();
        Supplier<class_3414> secondaryShootSoundEvent = this.fireModeConfig.secondaryShootSoundEvent();
        if (secondaryShootSoundEvent != null && (this.tickProgress == shootDelayInTicks || (this.tickProgress + shootDelayInTicks) % secondaryShootSoundFrequencyInTicks == 0)) {
            level.method_45447(null, this.shooter.method_24515(), secondaryShootSoundEvent.get(), class_3419.field_15248);
        }
    }

    private void playPrimaryShootSoundEffects() {
        class_1937 level = this.shooter.method_37908();
        int primaryShootSoundFrequencyInTicks = this.fireModeConfig.primaryShootSoundFrequencyInTicks();
        if (primaryShootSoundFrequencyInTicks <= 0 || this.tickProgress % primaryShootSoundFrequencyInTicks == 0) {
            level.method_45447(null, this.shooter.method_24515(), this.fireModeConfig.primaryShootSoundEvent().get(), class_3419.field_15248);
        }
    }
}

