/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.power.grid;

import com.human.common.gameplay.power.PowerNode;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class PowerGrid {
    private final Set<PowerNode.PowerConsumer> consumers = new HashSet<PowerNode.PowerConsumer>();
    private final Set<PowerNode.PowerProducer> producers = new HashSet<PowerNode.PowerProducer>();
    private final Set<PowerNode.PowerStore> stores = new HashSet<PowerNode.PowerStore>();

    public void add(PowerNode node) {
        PowerNode powerNode = node;
        Objects.requireNonNull(powerNode);
        PowerNode powerNode2 = powerNode;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PowerNode.PowerStore.class, PowerNode.PowerConsumer.class, PowerNode.PowerProducer.class}, (Object)powerNode2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                PowerNode.PowerStore powerStore = (PowerNode.PowerStore)powerNode2;
                this.stores.add(powerStore);
                break;
            }
            case 1: {
                PowerNode.PowerConsumer powerConsumer = (PowerNode.PowerConsumer)powerNode2;
                this.consumers.add(powerConsumer);
                break;
            }
            case 2: {
                PowerNode.PowerProducer powerProducer = (PowerNode.PowerProducer)powerNode2;
                this.producers.add(powerProducer);
            }
        }
    }

    public void remove(PowerNode node) {
        PowerNode powerNode = node;
        Objects.requireNonNull(powerNode);
        PowerNode powerNode2 = powerNode;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PowerNode.PowerStore.class, PowerNode.PowerConsumer.class, PowerNode.PowerProducer.class}, (Object)powerNode2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                PowerNode.PowerStore powerStore = (PowerNode.PowerStore)powerNode2;
                this.stores.remove(powerStore);
                break;
            }
            case 1: {
                PowerNode.PowerConsumer powerConsumer = (PowerNode.PowerConsumer)powerNode2;
                this.consumers.remove(powerConsumer);
                break;
            }
            case 2: {
                PowerNode.PowerProducer powerProducer = (PowerNode.PowerProducer)powerNode2;
                this.producers.remove(powerProducer);
            }
        }
    }

    public void tick() {
        long availableFromProducers = this.producers.stream().mapToLong(PowerNode.PowerProducer::getAvailablePower).sum();
        if (availableFromProducers == 0L && this.stores.stream().mapToLong(PowerNode.PowerStore::getStoredPower).sum() == 0L) {
            return;
        }
        long requestedByConsumers = this.consumers.stream().mapToLong(PowerNode.PowerConsumer::getRequestedPower).sum();
        boolean consumersFullyPowered = false;
        if (requestedByConsumers > 0L) {
            if (availableFromProducers >= requestedByConsumers) {
                consumersFullyPowered = true;
                for (PowerNode.PowerConsumer consumer : this.consumers) {
                    long requested = consumer.getRequestedPower();
                    consumer.receivePower(requested);
                }
                for (PowerNode.PowerProducer producer : this.producers) {
                    long offered = producer.getAvailablePower();
                    producer.extractPower(offered);
                }
            } else {
                long requiredExtra = requestedByConsumers - availableFromProducers;
                long availableFromStores = this.stores.stream().mapToLong(PowerNode.PowerStore::getStoredPower).sum();
                if (availableFromProducers + availableFromStores >= requestedByConsumers) {
                    consumersFullyPowered = true;
                    for (PowerNode.PowerProducer producer : this.producers) {
                        long offered = producer.getAvailablePower();
                        producer.extractPower(offered);
                    }
                    long stillNeeded = requiredExtra;
                    for (PowerNode.PowerStore store : this.stores) {
                        if (stillNeeded <= 0L) break;
                        long drawn = store.extractPower(stillNeeded);
                        stillNeeded -= drawn;
                    }
                    for (PowerNode.PowerConsumer consumer : this.consumers) {
                        long requested = consumer.getRequestedPower();
                        consumer.receivePower(requested);
                    }
                }
            }
        }
        if (consumersFullyPowered || requestedByConsumers == 0L) {
            long usedByConsumers = requestedByConsumers;
            long usedByProducers = Math.min(availableFromProducers, usedByConsumers);
            long surplus = availableFromProducers - usedByProducers;
            if (surplus > 0L) {
                for (PowerNode.PowerStore store : this.stores) {
                    if (surplus <= 0L) break;
                    long accepted = store.receivePower(surplus);
                    surplus -= accepted;
                }
            }
            for (PowerNode.PowerProducer producer : this.producers) {
                long offered = producer.getAvailablePower();
                producer.extractPower(offered);
            }
        }
    }

    public void addAll(Collection<? extends PowerNode> nodes) {
        nodes.forEach(this::add);
    }

    public void removeAll(Collection<? extends PowerNode> nodes) {
        nodes.forEach(this::remove);
    }

    public Set<PowerNode.PowerConsumer> getConsumers() {
        return Collections.unmodifiableSet(this.consumers);
    }

    public Set<PowerNode.PowerProducer> getProducers() {
        return Collections.unmodifiableSet(this.producers);
    }

    public Set<PowerNode.PowerStore> getStores() {
        return Collections.unmodifiableSet(this.stores);
    }
}

