/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.power.grid;

import com.human.common.gameplay.power.PowerNode;
import com.human.common.gameplay.power.grid.PowerGrid;
import com.human.common.gameplay.power.grid.PowerGridDSU;
import com.human.common.gameplay.power.grid.PowerGridExploreUtil;
import com.lib.common.util.DirectionUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;

public class PowerGridManager {
    private final PowerGridDSU dsu = new PowerGridDSU();
    private final Map<class_2338, PowerGrid> grids = new HashMap<class_2338, PowerGrid>();

    public void tick() {
        for (PowerGrid grid : this.grids.values()) {
            grid.tick();
        }
    }

    public void union(class_2338 a, class_2338 b) {
        class_2338 rootB;
        class_2338 rootA = this.dsu.find(a);
        if (rootA.equals((Object)(rootB = this.dsu.find(b)))) {
            return;
        }
        PowerGrid gridA = this.grids.computeIfAbsent(rootA, r -> new PowerGrid());
        PowerGrid gridB = this.grids.computeIfAbsent(rootB, r -> new PowerGrid());
        gridA.getProducers().forEach(gridB::add);
        gridA.getConsumers().forEach(gridB::add);
        gridA.getStores().forEach(gridB::add);
        this.grids.remove(rootA);
        this.dsu.setParent(rootA, rootB);
    }

    public void splitGrid(class_1937 level, class_2338 removedPos) {
        class_2338 oldRoot = this.dsu.find(removedPos);
        this.dsu.remove(removedPos);
        this.grids.remove(oldRoot);
        HashSet<class_2338> visited = new HashSet<class_2338>();
        for (class_2350 direction : DirectionUtil.VALUES) {
            class_2338 neighbor = removedPos.method_10093(direction);
            if (visited.contains(neighbor) || !PowerGridExploreUtil.isConnectable(level, neighbor)) continue;
            Set<class_2338> component = PowerGridExploreUtil.discover(level, neighbor);
            class_2338 newRoot = component.iterator().next();
            PowerGrid grid = new PowerGrid();
            this.grids.put(newRoot, grid);
            for (class_2338 pos : component) {
                this.dsu.setParent(pos, newRoot);
                visited.add(pos);
                class_2586 blockEntity = level.method_8321(pos);
                if (!(blockEntity instanceof PowerNode)) continue;
                PowerNode node = (PowerNode)blockEntity;
                grid.add(node);
            }
        }
    }

    public void registerNode(class_2338 pos, PowerNode node) {
        class_2338 root = this.dsu.find(pos);
        this.grids.computeIfAbsent(root, r -> new PowerGrid()).add(node);
    }

    public void unregisterNode(class_2338 pos, PowerNode node) {
        class_2338 root = this.dsu.find(pos);
        PowerGrid grid = this.grids.get(root);
        if (grid != null) {
            grid.remove(node);
        }
    }
}

