/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.entity.ai.action;

import com.just.core.functional.option.None;
import com.just.core.functional.option.Option;
import com.lib.common.gameplay.entity.ai.GOAPConstants;
import com.lib.common.gameplay.entity.ai.util.CombatResponse;
import com.lib.common.gameplay.goap.GOAPAction;
import com.lib.common.gameplay.goap.TypedIdentifier;
import com.lib.common.gameplay.goap.condition.expression.GOAPExpression;
import com.lib.common.gameplay.goap.effect.GOAPEffect;
import com.lib.common.gameplay.goap.state.GOAPBlackboard;
import com.lib.common.gameplay.goap.state.GOAPWorldState;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_5532;

public class AvoidAction<T extends class_1314>
extends GOAPAction<T> {
    private static final TypedIdentifier<class_11> AVOID_PATH = new TypedIdentifier("avoidPath");
    private static final TypedIdentifier<class_2338> AVOID_PATH_TARGET_POS = new TypedIdentifier("avoidPathTargetPos");
    private final int avoidRange;
    private final float avoidSpeedModifier;

    public AvoidAction(int avoidRange, float avoidSpeedModifier) {
        this.avoidRange = avoidRange;
        this.avoidSpeedModifier = avoidSpeedModifier;
        this.addPrecondition(GOAPConstants.COMBAT_RESPONSE, GOAPExpression.equalTo(CombatResponse.flight()));
        this.addPrecondition(GOAPConstants.NEAREST_ATTACK_TARGET_ENTITY, GOAPExpression.isSome());
        this.addPrecondition(GOAPConstants.IS_ATTACK_TARGET_ENTITY_IN_RANGE, GOAPExpression.isTrue());
        this.addEffect(new GOAPEffect.Value<None>(GOAPConstants.NEAREST_ATTACK_TARGET_ENTITY, Option.none()));
    }

    @Override
    public boolean perform(T context, GOAPWorldState worldState, GOAPBlackboard blackboard) {
        Option targetOption = (Option)worldState.getOrDefault(GOAPConstants.NEAREST_ATTACK_TARGET_ENTITY, Option.none());
        if (targetOption.isNone()) {
            return true;
        }
        class_1309 target = (class_1309)targetOption.unwrap();
        if (target.method_29504() || context.method_5858((class_1297)target) > (double)(this.avoidRange * this.avoidRange)) {
            return true;
        }
        this.getOrCreateAvoidPath(context, target, blackboard).ifSome(avoidPath -> context.method_5942().method_6334(avoidPath, (double)this.avoidSpeedModifier));
        return context.method_5942().method_6357();
    }

    @Override
    public void onFinish(T context, GOAPWorldState worldState, GOAPBlackboard blackboard) {
        context.method_5942().method_6340();
    }

    private Option<class_11> getOrCreateAvoidPath(T context, class_1309 toAvoid, GOAPBlackboard blackboard) {
        class_11 currentAvoidPath = blackboard.get(AVOID_PATH);
        class_2338 cachedTargetPos = blackboard.get(AVOID_PATH_TARGET_POS);
        class_2338 currentTargetPos = toAvoid.method_24515();
        if (currentAvoidPath != null && cachedTargetPos != null && cachedTargetPos.equals((Object)currentTargetPos)) {
            return Option.some((Object)currentAvoidPath);
        }
        class_243 vec3 = class_5532.method_31511(context, (int)(this.avoidRange + this.avoidRange / 2), (int)7, (class_243)toAvoid.method_19538());
        if (vec3 == null) {
            return Option.none();
        }
        if (toAvoid.method_5649(vec3.field_1352, vec3.field_1351, vec3.field_1350) < toAvoid.method_5858(context)) {
            return Option.none();
        }
        class_11 avoidPath = context.method_5942().method_6352(vec3.field_1352, vec3.field_1351, vec3.field_1350, 0);
        if (avoidPath != null) {
            blackboard.set(AVOID_PATH, avoidPath);
            blackboard.set(AVOID_PATH_TARGET_POS, currentTargetPos);
        }
        return Option.ofNullable((Object)avoidPath);
    }
}

