/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.entity.ai.action;

import com.avp.common.model.inventory.AVPInventoryBearer;
import com.just.core.functional.option.None;
import com.just.core.functional.option.Option;
import com.lib.common.gameplay.entity.ai.GOAPConstants;
import com.lib.common.gameplay.entity.ai.util.CombatResponse;
import com.lib.common.gameplay.goap.GOAPAction;
import com.lib.common.gameplay.goap.TypedIdentifier;
import com.lib.common.gameplay.goap.condition.expression.GOAPExpression;
import com.lib.common.gameplay.goap.effect.GOAPEffect;
import com.lib.common.gameplay.goap.state.GOAPBlackboard;
import com.lib.common.gameplay.goap.state.GOAPWorldState;
import java.util.function.Function;
import net.minecraft.class_1308;
import net.minecraft.class_1542;

public class PickUpItemAction<T extends class_1308>
extends GOAPAction<T> {
    private final TypedIdentifier<Option<? extends class_1542>> itemEntityIdentifier;
    private final Function<GOAPWorldState, Float> costFunction;

    public PickUpItemAction(TypedIdentifier<Option<? extends class_1542>> itemEntityIdentifier, TypedIdentifier<Boolean> isInRangeIdentifier, Function<GOAPWorldState, Float> costFunction) {
        this.itemEntityIdentifier = itemEntityIdentifier;
        this.costFunction = costFunction;
        this.addPrecondition(GOAPConstants.COMBAT_RESPONSE, GOAPExpression.equalTo(CombatResponse.rest()));
        this.addPrecondition(itemEntityIdentifier, GOAPExpression.isSome());
        this.addPrecondition(GOAPConstants.HAS_FREE_INVENTORY_SLOT, GOAPExpression.isTrue());
        this.addPrecondition(isInRangeIdentifier, GOAPExpression.isTrue());
        this.addEffect(new GOAPEffect.Value<None>(itemEntityIdentifier, Option.none()));
    }

    @Override
    public boolean perform(T context, GOAPWorldState worldState, GOAPBlackboard blackboard) {
        ((Option)worldState.getOrDefault(this.itemEntityIdentifier, Option.none())).ifSome(nearestItemEntity -> ((AVPInventoryBearer)context).getInventory().pickUpItem((class_1542)nearestItemEntity));
        return true;
    }

    @Override
    public float getCost(T context, GOAPWorldState worldState) {
        return this.costFunction.apply(worldState).floatValue();
    }
}

