/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.gene;

import com.avp.common.registry.AVPDeferredHolder;
import com.just.core.functional.option.Option;
import com.lib.common.gameplay.gene.Gene;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class GeneRegistry {
    private static final Map<class_2960, Gene> GENES_BY_RESOURCE_LOCATION = new HashMap<class_2960, Gene>();
    private static final Map<Gene, class_2960> RESOURCE_LOCATION_BY_VALUE = new HashMap<Gene, class_2960>();

    @Nullable
    public static Gene getValueOrNull(class_2960 resourceLocation) {
        return GENES_BY_RESOURCE_LOCATION.get(resourceLocation);
    }

    @Nullable
    public static class_2960 getResourceLocationOrNull(AVPDeferredHolder<Gene> geneHolder) {
        return RESOURCE_LOCATION_BY_VALUE.get(geneHolder.get());
    }

    public static Option<Gene> getValue(class_2960 resourceLocation) {
        return Option.ofNullable((Object)GeneRegistry.getValueOrNull(resourceLocation));
    }

    public static Option<class_2960> getResourceLocation(AVPDeferredHolder<Gene> geneHolder) {
        return Option.ofNullable((Object)GeneRegistry.getResourceLocationOrNull(geneHolder));
    }

    public static AVPDeferredHolder<Gene> register(Supplier<Gene> geneSupplier) {
        Gene gene = geneSupplier.get();
        class_2960 resourceLocation = gene.id();
        class_6880 holder = class_6880.method_40223((Object)gene);
        GENES_BY_RESOURCE_LOCATION.put(resourceLocation, gene);
        RESOURCE_LOCATION_BY_VALUE.put(gene, resourceLocation);
        return new AVPDeferredHolder<Gene>(() -> gene, () -> holder);
    }
}

