/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.goap.plan;

import com.just.core.functional.option.Option;
import com.lib.common.gameplay.goap.GOAPAction;
import com.lib.common.gameplay.goap.GOAPGoal;
import com.lib.common.gameplay.goap.state.GOAPBlackboard;
import com.lib.common.gameplay.goap.state.GOAPWorldState;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GOAPPlan<T> {
    private final GOAPGoal goal;
    private final List<GOAPAction<T>> actions;
    private final GOAPBlackboard blackboard;
    private int currentActionIndex;

    public GOAPPlan(GOAPGoal goal, List<GOAPAction<T>> actions) {
        this.goal = goal;
        this.actions = actions;
        this.blackboard = new GOAPBlackboard();
        this.currentActionIndex = 0;
    }

    public State update(T context, GOAPWorldState currentState) {
        if (this.currentActionIndex >= this.actions.size()) {
            return new State.Finished();
        }
        GOAPAction<T> action = this.actions.get(this.currentActionIndex);
        if (!action.getPreconditions().satisfiedBy(currentState)) {
            action.onFinish(context, currentState, this.blackboard);
            return new State.Invalid();
        }
        if (currentState.satisfies(action.getEffects()) || action.perform(context, currentState, this.blackboard)) {
            action.onFinish(context, currentState, this.blackboard);
            return this.proceedToNextActionOrFinish();
        }
        return new State.InProgress();
    }

    @NotNull
    private State proceedToNextActionOrFinish() {
        ++this.currentActionIndex;
        return this.currentActionIndex >= this.actions.size() ? new State.Finished() : new State.InProgress();
    }

    public Option<GOAPAction<T>> getCurrentAction() {
        return this.currentActionIndex >= this.actions.size() ? Option.none() : Option.some(this.actions.get(this.currentActionIndex));
    }

    public static sealed interface State {

        public record Invalid() implements State
        {
        }

        public record InProgress() implements State
        {
        }

        public record Failed() implements State
        {
        }

        public record Finished() implements State
        {
        }
    }
}

