/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.goap.plan;

import com.just.core.functional.option.Option;
import com.lib.common.gameplay.goap.GOAP;
import com.lib.common.gameplay.goap.GOAPAction;
import com.lib.common.gameplay.goap.GOAPGoal;
import com.lib.common.gameplay.goap.condition.GOAPCondition;
import com.lib.common.gameplay.goap.condition.GOAPConditionContainer;
import com.lib.common.gameplay.goap.plan.GOAPPlan;
import com.lib.common.gameplay.goap.state.GOAPMutableWorldState;
import com.lib.common.gameplay.goap.state.GOAPWorldState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GOAPPlanner<T> {
    private final GOAP<T> goap;

    public GOAPPlanner(GOAP<T> goap) {
        this.goap = goap;
    }

    public Option<GOAPPlan<T>> createPlan(T context, GOAPWorldState currentState, Collection<GOAPGoal> goals) {
        GOAPPlan bestPlan = null;
        float bestCost = Float.MAX_VALUE;
        for (GOAPGoal goal : goals) {
            List plan2;
            Float cost;
            GOAPConditionContainer desiredConditions = goal.getDesiredConditions();
            Option<List<GOAPAction<T>>> planOption = this.buildPlanForConditions(desiredConditions, currentState);
            if (!planOption.isSomeAnd(plan -> !plan.isEmpty()) || !((cost = (plan2 = (List)planOption.unwrap()).stream().map(action -> Float.valueOf(action.getCost(context, currentState))).reduce(Float.valueOf(0.0f), Float::sum)).floatValue() < bestCost)) continue;
            bestCost = cost.floatValue();
            bestPlan = new GOAPPlan(goal, plan2);
        }
        return Option.ofNullable(bestPlan);
    }

    private Option<List<GOAPAction<T>>> buildPlanForConditions(GOAPConditionContainer desiredConditions, GOAPWorldState currentState) {
        if (currentState.satisfies(desiredConditions)) {
            return Option.some(List.of());
        }
        ArrayList<GOAPAction> plan = new ArrayList<GOAPAction>();
        GOAPMutableWorldState workingState = new GOAPMutableWorldState(currentState);
        for (GOAPCondition<?> condition : desiredConditions.getConditions()) {
            if (condition.satisfiedBy(workingState)) continue;
            List<GOAPAction> satisfyingActions = this.goap.getAvailableActions().stream().filter(action -> condition.satisfiedBy(action.getEffects())).toList();
            boolean satisfied = false;
            for (GOAPAction action2 : satisfyingActions) {
                Option<List<GOAPAction<T>>> subPlanOption = this.buildPlanForConditions(action2.getPreconditions(), workingState);
                if (!subPlanOption.isSome()) continue;
                List subPlan = (List)subPlanOption.unwrap();
                plan.addAll(subPlan);
                plan.add(action2);
                workingState.apply(action2.getEffects());
                satisfied = true;
                break;
            }
            if (satisfied) continue;
            return Option.none();
        }
        return Option.some(plan);
    }
}

