/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.registry;

import com.lib.common.network.DataKey;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class DataKeyRegistry {
    private static final Map<Integer, class_2960> ID_TO_RESOURCE_LOCATION = new HashMap<Integer, class_2960>();
    private static final Map<class_2960, Integer> RESOURCE_LOCATION_TO_ID = new HashMap<class_2960, Integer>();
    private static final Map<class_2960, DataKey<?>> RESOURCE_LOCATION_TO_DATA_KEY = new HashMap();
    private static final AtomicInteger NEXT_FREE_ID = new AtomicInteger(0);

    public static <T> DataKey<T> register(class_2960 resourceLocation, DataKey<T> dataKey) {
        int id = NEXT_FREE_ID.getAndIncrement();
        ID_TO_RESOURCE_LOCATION.put(id, resourceLocation);
        RESOURCE_LOCATION_TO_ID.put(resourceLocation, id);
        RESOURCE_LOCATION_TO_DATA_KEY.put(resourceLocation, dataKey);
        return dataKey;
    }

    @Nullable
    public static class_2960 getResourceLocationOrNull(int id) {
        return ID_TO_RESOURCE_LOCATION.get(id);
    }

    @Nullable
    public static Integer getIdOrNull(class_2960 resourceLocation) {
        return RESOURCE_LOCATION_TO_ID.get(resourceLocation);
    }

    @Nullable
    public static DataKey<?> getDataKeyOrNull(int id) {
        class_2960 resourceLocation = DataKeyRegistry.getResourceLocationOrNull(id);
        return resourceLocation == null ? null : DataKeyRegistry.getDataKeyOrNull(resourceLocation);
    }

    @Nullable
    public static DataKey<?> getDataKeyOrNull(class_2960 resourceLocation) {
        return RESOURCE_LOCATION_TO_DATA_KEY.get(resourceLocation);
    }
}

