/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.registry;

import com.lib.common.gameplay.gene.GeneBonusData;
import com.lib.common.gameplay.gene.GeneModifierKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_7923;

public class GeneBonusDataRegistry {
    private static final List<GeneBonusData> GENE_BONUS_MAPS = new ArrayList<GeneBonusData>();
    private static final Map<class_1299<?>, Map<GeneModifierKey, Double>> ENTITY_TYPE_TO_GENE_BONUS_MAP = new HashMap();

    public static boolean has(class_1299<?> entityType) {
        return ENTITY_TYPE_TO_GENE_BONUS_MAP.containsKey(entityType);
    }

    public static Map<GeneModifierKey, Double> getOrDefault(class_1299<?> entityType) {
        return ENTITY_TYPE_TO_GENE_BONUS_MAP.getOrDefault(entityType, Map.of());
    }

    public static void clear() {
        GENE_BONUS_MAPS.clear();
    }

    public static void register(GeneBonusData geneBonusData) {
        GENE_BONUS_MAPS.add(geneBonusData);
    }

    public static void rebuildLookupMappings() {
        ENTITY_TYPE_TO_GENE_BONUS_MAP.clear();
        GENE_BONUS_MAPS.forEach(GeneBonusDataRegistry::compute);
    }

    public static void compute(GeneBonusData geneBonusData) {
        class_7923.field_41177.method_10220().filter(geneBonusData.entityTypePredicate()::test).forEach(entityType -> geneBonusData.geneBonusDataEntries().forEach(geneBonusDataEntry -> ENTITY_TYPE_TO_GENE_BONUS_MAP.computeIfAbsent((class_1299<?>)entityType, $ -> new HashMap()).merge(geneBonusDataEntry.toKey(), geneBonusDataEntry.value(), Double::sum)));
    }
}

