/*
 * Decompiled with CFR 0.152.
 */
package com.alien.client.animation.entity;

import com.alien.common.gameplay.entity.living.alien.xenomorph.queen.Queen;
import com.alien.common.gameplay.entity.living.alien.xenomorph.queen.QueenAnimationDispatcher;
import com.avp.AVPResources;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.animation.AzAnimatorConfig;
import mod.azure.azurelib.rewrite.animation.controller.AzAnimationController;
import mod.azure.azurelib.rewrite.animation.controller.AzAnimationControllerContainer;
import mod.azure.azurelib.rewrite.animation.impl.AzEntityAnimator;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.model.AzBone;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class QueenAnimator
extends AzEntityAnimator<Queen> {
    private static final String NAME = "queen";
    private static final ResourceLocation ANIMATION = AVPResources.entityAnimationLocation("queen");

    public QueenAnimator() {
        super(AzAnimatorConfig.defaultConfig());
    }

    public void registerControllers(AzAnimationControllerContainer<Queen> animationControllerContainer) {
        animationControllerContainer.add(AzAnimationController.builder((AzAnimator)this, (String)"body").setTransitionLength(5).build(), new AzAnimationController[]{AzAnimationController.builder((AzAnimator)this, (String)"head").setTransitionLength(5).build(), AzAnimationController.builder((AzAnimator)this, (String)"leftarm").setTransitionLength(5).build(), AzAnimationController.builder((AzAnimator)this, (String)"leftleg").setTransitionLength(5).build(), AzAnimationController.builder((AzAnimator)this, (String)"lefttittyarm").setTransitionLength(5).build(), AzAnimationController.builder((AzAnimator)this, (String)"rightarm").setTransitionLength(5).build(), AzAnimationController.builder((AzAnimator)this, (String)"rightleg").setTransitionLength(5).build(), AzAnimationController.builder((AzAnimator)this, (String)"righttittyarm").setTransitionLength(5).build(), AzAnimationController.builder((AzAnimator)this, (String)"tail").setTransitionLength(5).build()});
    }

    @NotNull
    public ResourceLocation getAnimationLocation(Queen animatable) {
        return ANIMATION;
    }

    public void setCustomAnimations(Queen animatable, float partialTicks) {
        super.setCustomAnimations((Object)animatable, partialTicks);
        this.runPassiveAnimations(animatable);
        AzBakedModel bakedModel = this.context().boneCache().getBakedModel();
        AzBone eggSack = bakedModel.getBoneOrNull("root2");
        if (eggSack != null) {
            eggSack.setHidden(true);
        }
    }

    private void runPassiveAnimations(Queen queen) {
        boolean isMovingOnGround;
        QueenAnimationDispatcher dispatcher = queen.getAnimationDispatcher();
        boolean bl = isMovingOnGround = (Boolean)queen.isMovingHorizontally.get() != false && queen.onGround();
        Runnable animFunction = queen.getOvipositorManager().hasOvipositor() ? dispatcher::sitOnOvipositor : (queen.isUnderWater() ? dispatcher::swim : (isMovingOnGround ? (((Boolean)queen.hasTarget.get()).booleanValue() ? dispatcher::run : dispatcher::walk) : dispatcher::idle));
        animFunction.run();
    }
}

