/*
 * Decompiled with CFR 0.152.
 */
package com.alien.client.render.entity;

import com.alien.client.animation.entity.AdolescentAnimator;
import com.alien.common.gameplay.entity.living.alien.adolescent.Adolescent;
import com.avp.AVPResources;
import com.mojang.blaze3d.vertex.PoseStack;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRenderer;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererConfig;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class AdolescentRenderer
extends AzEntityRenderer<Adolescent> {
    private static final float DEFAULT_SHADOW_SIZE = 0.4f;
    private static final String NAME = "adolescent";
    private static final ResourceLocation MODEL = AVPResources.entityGeoModelLocation("adolescent");
    private static final ResourceLocation ROYAL_MODEL = AVPResources.entityGeoModelLocation("royal_adolescent");
    private static final ResourceLocation TEXTURE = AVPResources.entityTextureLocation("adolescent");
    private static final ResourceLocation ABERRANT_TEXTURE = AVPResources.entityTextureLocation("aberrant_adolescent");
    private static final ResourceLocation NETHER_TEXTURE = AVPResources.entityTextureLocation("nether_adolescent");
    private static final ResourceLocation ROYAL_TEXTURE = AVPResources.entityTextureLocation("royal_adolescent");
    private static final ResourceLocation ABERRANT_ROYAL_TEXTURE = AVPResources.entityTextureLocation("royal_aberrant_adolescent");
    private static final ResourceLocation NETHER_ROYAL_TEXTURE = AVPResources.entityTextureLocation("royal_nether_adolescent");

    public AdolescentRenderer(EntityRendererProvider.Context context) {
        super(AzEntityRendererConfig.builder(AdolescentRenderer::modelLocation, AdolescentRenderer::textureLocation).setAnimatorProvider(AdolescentAnimator::new).build(), context);
        this.shadowRadius = 0.4f;
    }

    public void render(@NotNull Adolescent entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        float scale = 0.7f;
        this.shadowRadius = 0.4f * scale;
        poseStack.pushPose();
        poseStack.scale(scale, scale, scale);
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        poseStack.popPose();
    }

    public static ResourceLocation modelLocation(Adolescent adolescent) {
        if (adolescent.isRoyal()) {
            return ROYAL_MODEL;
        }
        return MODEL;
    }

    public static ResourceLocation textureLocation(Adolescent adolescent) {
        if (adolescent.isRoyal()) {
            if (adolescent.isNetherAfflicted()) {
                return NETHER_ROYAL_TEXTURE;
            }
            if (adolescent.isAberrant()) {
                return ABERRANT_ROYAL_TEXTURE;
            }
            return ROYAL_TEXTURE;
        }
        if (!adolescent.isRoyal()) {
            if (adolescent.isNetherAfflicted()) {
                return NETHER_TEXTURE;
            }
            if (adolescent.isAberrant()) {
                return ABERRANT_TEXTURE;
            }
        }
        return TEXTURE;
    }
}

