/*
 * Decompiled with CFR 0.152.
 */
package com.alien.client.render.entity;

import com.alien.client.animation.entity.DroneAnimator;
import com.alien.common.gameplay.entity.living.alien.xenomorph.drone.Drone;
import com.avp.AVPResources;
import com.avp.client.render.layer.RadiationGlowLayer;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRenderer;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererConfig;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;

public class DroneRenderer
extends AzEntityRenderer<Drone> {
    private static final String NAME = "drone";
    private static final ResourceLocation MODEL = AVPResources.entityGeoModelLocation("drone");
    private static final ResourceLocation TEXTURE = AVPResources.entityTextureLocation("drone");
    private static final ResourceLocation ABERRANT_TEXTURE = AVPResources.entityTextureLocation("aberrant_drone");
    private static final ResourceLocation IRRADIATED_TEXTURE = AVPResources.entityTextureLocation("irradiated_drone");
    private static final ResourceLocation NETHER_TEXTURE = AVPResources.entityTextureLocation("nether_drone");

    public DroneRenderer(EntityRendererProvider.Context context) {
        super(AzEntityRendererConfig.builder($ -> MODEL, DroneRenderer::textureLocation).setAnimatorProvider(DroneAnimator::new).addRenderLayer(new RadiationGlowLayer()).build(), context);
        this.shadowRadius = 0.5f;
    }

    public static ResourceLocation textureLocation(Drone drone) {
        if (drone.isNetherAfflicted()) {
            return NETHER_TEXTURE;
        }
        if (drone.isIrradiated()) {
            return IRRADIATED_TEXTURE;
        }
        if (drone.isAberrant()) {
            return ABERRANT_TEXTURE;
        }
        return TEXTURE;
    }
}

