/*
 * Decompiled with CFR 0.152.
 */
package com.alien.client.render.entity;

import com.alien.client.animation.entity.OvomorphAnimator;
import com.alien.common.gameplay.entity.living.alien.ovomorph.Ovomorph;
import com.avp.AVPResources;
import com.mojang.blaze3d.vertex.PoseStack;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRenderer;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererConfig;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class OvomorphRenderer
extends AzEntityRenderer<Ovomorph> {
    private static final String NAME = "ovomorph";
    private static final ResourceLocation MODEL = AVPResources.entityGeoModelLocation("ovomorph");
    private static final ResourceLocation ROYAL_MODEL = AVPResources.entityGeoModelLocation("royal_ovomorph");
    private static final ResourceLocation TEXTURE = AVPResources.entityTextureLocation("ovomorph");
    private static final ResourceLocation ABERRANT_TEXTURE = AVPResources.entityTextureLocation("aberrant_ovomorph");
    private static final ResourceLocation NETHER_TEXTURE = AVPResources.entityTextureLocation("nether_ovomorph");
    private static final ResourceLocation ROYAL_TEXTURE = AVPResources.entityTextureLocation("royal_ovomorph");
    private static final ResourceLocation ABERRANT_ROYAL_TEXTURE = AVPResources.entityTextureLocation("royal_aberrant_ovomorph");
    private static final ResourceLocation NETHER_ROYAL_TEXTURE = AVPResources.entityTextureLocation("royal_nether_ovomorph");

    public OvomorphRenderer(EntityRendererProvider.Context context) {
        super(AzEntityRendererConfig.builder(OvomorphRenderer::modelLocation, OvomorphRenderer::textureLocation).setAnimatorProvider(OvomorphAnimator::new).setRenderType(OvomorphRenderer::getEggRenderType).build(), context);
        this.shadowRadius = 0.4f;
    }

    public void render(@NotNull Ovomorph entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        float scale = 1.35f;
        poseStack.pushPose();
        poseStack.scale(scale, scale, scale);
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        poseStack.popPose();
    }

    public static ResourceLocation modelLocation(Ovomorph ovomorph) {
        if (ovomorph.isRoyal()) {
            return ROYAL_MODEL;
        }
        return MODEL;
    }

    public static ResourceLocation textureLocation(Ovomorph ovomorph) {
        if (ovomorph.isRoyal()) {
            if (ovomorph.isNetherAfflicted()) {
                return NETHER_ROYAL_TEXTURE;
            }
            if (ovomorph.isAberrant()) {
                return ABERRANT_ROYAL_TEXTURE;
            }
            return ROYAL_TEXTURE;
        }
        if (!ovomorph.isRoyal()) {
            if (ovomorph.isNetherAfflicted()) {
                return NETHER_TEXTURE;
            }
            if (ovomorph.isAberrant()) {
                return ABERRANT_TEXTURE;
            }
        }
        return TEXTURE;
    }

    public static RenderType getEggRenderType(Ovomorph ovomorph) {
        if (ovomorph.getHatchManager().isHatching() || ovomorph.getHatchManager().isHatched()) {
            return RenderType.entityTranslucent((ResourceLocation)OvomorphRenderer.textureLocation(ovomorph));
        }
        return RenderType.entityCutoutNoCull((ResourceLocation)OvomorphRenderer.textureLocation(ovomorph));
    }
}

