/*
 * Decompiled with CFR 0.152.
 */
package com.alien.client.render.entity;

import com.alien.client.animation.entity.QueenAnimator;
import com.alien.common.gameplay.entity.living.alien.xenomorph.queen.Queen;
import com.avp.AVPResources;
import com.avp.client.render.layer.RadiationGlowLayer;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRenderer;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererConfig;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;

public class QueenRenderer
extends AzEntityRenderer<Queen> {
    private static final String NAME = "queen";
    private static final ResourceLocation MODEL = AVPResources.entityGeoModelLocation("queen");
    private static final ResourceLocation TEXTURE = AVPResources.entityTextureLocation("queen");
    private static final ResourceLocation ABERRANT_TEXTURE = AVPResources.entityTextureLocation("aberrant_queen");
    private static final ResourceLocation IRRADIATED_TEXTURE = AVPResources.entityTextureLocation("irradiated_queen");
    private static final ResourceLocation NETHER_TEXTURE = AVPResources.entityTextureLocation("nether_queen");

    public QueenRenderer(EntityRendererProvider.Context context) {
        super(AzEntityRendererConfig.builder($ -> MODEL, QueenRenderer::textureLocation).setAnimatorProvider(QueenAnimator::new).addRenderLayer(new RadiationGlowLayer()).build(), context);
        this.shadowRadius = 1.0f;
    }

    private static ResourceLocation textureLocation(Queen queen) {
        if (queen.isNetherAfflicted()) {
            return NETHER_TEXTURE;
        }
        if (queen.isIrradiated()) {
            return IRRADIATED_TEXTURE;
        }
        if (queen.isAberrant()) {
            return ABERRANT_TEXTURE;
        }
        return TEXTURE;
    }
}

