/*
 * Decompiled with CFR 0.152.
 */
package com.alien.client.render.entity;

import com.alien.client.animation.entity.RunnerAnimator;
import com.alien.common.gameplay.entity.living.alien.xenomorph.runner.Runner;
import com.avp.AVPResources;
import com.avp.client.render.layer.RadiationGlowLayer;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRenderer;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererConfig;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;

public class RunnerRenderer
extends AzEntityRenderer<Runner> {
    private static final String NAME = "runner";
    private static final ResourceLocation MODEL = AVPResources.entityGeoModelLocation("runner");
    private static final ResourceLocation TEXTURE = AVPResources.entityTextureLocation("runner");
    private static final ResourceLocation ABERRANT_TEXTURE = AVPResources.entityTextureLocation("aberrant_runner");
    private static final ResourceLocation IRRADIATED_TEXTURE = AVPResources.entityTextureLocation("irradiated_runner");
    private static final ResourceLocation NETHER_TEXTURE = AVPResources.entityTextureLocation("nether_runner");

    public RunnerRenderer(EntityRendererProvider.Context context) {
        super(AzEntityRendererConfig.builder($ -> MODEL, RunnerRenderer::textureLocation).setAnimatorProvider(RunnerAnimator::new).addRenderLayer(new RadiationGlowLayer()).build(), context);
        this.shadowRadius = 0.5f;
    }

    public static ResourceLocation textureLocation(Runner runner) {
        if (runner.isNetherAfflicted()) {
            return NETHER_TEXTURE;
        }
        if (runner.isIrradiated()) {
            return IRRADIATED_TEXTURE;
        }
        if (runner.isAberrant()) {
            return ABERRANT_TEXTURE;
        }
        return TEXTURE;
    }
}

